/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.messages.impl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Random;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.util.ArrayUtils;
import org.limewire.security.AbstractSecurityToken;
import org.limewire.security.AddressSecurityToken;
import org.limewire.security.InvalidSecurityTokenException;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.security.SecurityToken;

public class DefaultMessageID
implements MessageID,
Comparable<DefaultMessageID> {
    private static final long serialVersionUID = -1477232241287654597L;
    public static final int LENGTH = 16;
    private static final Random GENERATOR = new Random();
    private static final byte[] RANDOM_PAD = new byte[4];
    private final byte[] messageId;
    private final int hashCode;
    private final MACCalculatorRepositoryManager macManager;

    private DefaultMessageID(byte[] messageId, MACCalculatorRepositoryManager macManager) {
        if (messageId == null) {
            throw new NullPointerException("messageId cannot be null");
        }
        if (messageId.length != 16) {
            throw new IllegalArgumentException("MessageID must be 16 bytes long: " + messageId.length);
        }
        this.macManager = macManager;
        this.messageId = messageId;
        this.hashCode = Arrays.hashCode(messageId);
    }

    public static DefaultMessageID createWithInputStream(InputStream in, MACCalculatorRepositoryManager manager) throws IOException {
        byte[] messageId = new byte[16];
        int len = -1;
        for (int r = 0; r < messageId.length; r += len) {
            len = in.read(messageId, r, messageId.length - r);
            if (len >= 0) continue;
            throw new EOFException();
        }
        return new DefaultMessageID(messageId, manager);
    }

    public static DefaultMessageID createWithBytes(byte[] messageId) {
        byte[] copy = new byte[messageId.length];
        System.arraycopy(messageId, 0, copy, 0, messageId.length);
        return new DefaultMessageID(copy, null);
    }

    public static DefaultMessageID createWithSocketAddress(SocketAddress dst, MACCalculatorRepositoryManager macManager) {
        byte[] messageId = new byte[16];
        GENERATOR.nextBytes(messageId);
        if (dst instanceof InetSocketAddress) {
            byte[] token = new MessageSecurityToken(new DHTTokenData(dst), macManager).getBytes();
            System.arraycopy(token, 0, messageId, 0, 4);
        }
        return new DefaultMessageID(messageId, macManager);
    }

    public static DefaultMessageID createWithHexString(String messageId) {
        return new DefaultMessageID(ArrayUtils.parseHexString(messageId), null);
    }

    @Override
    public void write(OutputStream os) throws IOException {
        os.write(this.messageId, 0, this.messageId.length);
    }

    @Override
    public int getLength() {
        return 16;
    }

    @Override
    public byte[] getBytes() {
        return this.getBytes(0, new byte[this.messageId.length], 0, this.messageId.length);
    }

    @Override
    public byte[] getBytes(int srcPos, byte[] dest, int destPos, int length) {
        System.arraycopy(this.messageId, srcPos, dest, destPos, length);
        return dest;
    }

    private SecurityToken getSecurityToken() throws InvalidSecurityTokenException {
        byte[] token = new byte[4];
        System.arraycopy(this.messageId, 0, token, 0, token.length);
        return new MessageSecurityToken(token, this.macManager);
    }

    @Override
    public boolean isTaggingSupported() {
        return true;
    }

    @Override
    public boolean isFor(SocketAddress src) {
        if (!(src instanceof InetSocketAddress)) {
            return false;
        }
        try {
            SecurityToken token = this.getSecurityToken();
            DHTTokenData data = new DHTTokenData(src);
            return token.isFor(data);
        }
        catch (InvalidSecurityTokenException iste) {
            return false;
        }
    }

    @Override
    public int compareTo(DefaultMessageID o) {
        int d = 0;
        for (int i = 0; i < this.messageId.length; ++i) {
            d = (this.messageId[i] & 0xFF) - (o.messageId[i] & 0xFF);
            if (d < 0) {
                return -1;
            }
            if (d <= 0) continue;
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultMessageID)) {
            return false;
        }
        return Arrays.equals(this.messageId, ((DefaultMessageID)o).messageId);
    }

    public String toHexString() {
        return ArrayUtils.toHexString(this.messageId);
    }

    public String toBinString() {
        return ArrayUtils.toBinString(this.messageId);
    }

    public String toString() {
        return "MessageID: " + this.toHexString();
    }

    static {
        GENERATOR.nextBytes(RANDOM_PAD);
    }

    public static class MessageSecurityToken
    extends AbstractSecurityToken {
        public MessageSecurityToken(byte[] network, MACCalculatorRepositoryManager manager) throws InvalidSecurityTokenException {
            super(network, manager);
        }

        public MessageSecurityToken(DHTTokenData data, MACCalculatorRepositoryManager manager) {
            super(data, manager);
        }

        @Override
        protected byte[] getFromMAC(byte[] mac, SecurityToken.TokenData ignored) {
            return mac;
        }

        public String toString() {
            return "MessageSecurityToken: " + ArrayUtils.toHexString(this.getBytes());
        }
    }

    public static class DHTTokenData
    extends AddressSecurityToken.AddressTokenData {
        private final SocketAddress addr;

        public DHTTokenData(SocketAddress addr) {
            super(addr);
            this.addr = addr;
            for (int i = 0; i < RANDOM_PAD.length; ++i) {
                int n = i;
                this.data[n] = (byte)(this.data[n] ^ RANDOM_PAD[i]);
            }
        }

        public String toString() {
            return "DHTTokenData: " + ArrayUtils.toHexString(this.getData()) + " for " + this.addr;
        }
    }
}

