/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.manager;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.limewire.mojito.Context;
import org.limewire.mojito.EntityKey;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureTask;
import org.limewire.mojito.concurrent.DHTTask;
import org.limewire.mojito.handler.response.FindValueResponseHandler;
import org.limewire.mojito.manager.AbstractManager;
import org.limewire.mojito.result.FindValueResult;

public class FindValueManager
extends AbstractManager<FindValueResult> {
    private final Map<EntityKey, FindValueFuture> futureMap = Collections.synchronizedMap(new HashMap());

    public FindValueManager(Context context) {
        super(context);
    }

    public void init() {
        this.futureMap.clear();
    }

    public DHTFuture<FindValueResult> lookup(EntityKey entityKey) {
        return this.lookup(entityKey, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DHTFuture<FindValueResult> lookup(EntityKey entityKey, int count) {
        FindValueFuture future = null;
        Map<EntityKey, FindValueFuture> map = this.futureMap;
        synchronized (map) {
            future = this.futureMap.get(entityKey);
            if (future == null) {
                FindValueResponseHandler handler = new FindValueResponseHandler(this.context, entityKey);
                future = new FindValueFuture(entityKey, handler);
                this.futureMap.put(entityKey, future);
                this.context.getDHTExecutorService().execute(future);
            }
        }
        return future;
    }

    private class FindValueFuture
    extends DHTFutureTask<FindValueResult> {
        private final EntityKey entityKey;
        private final DHTTask<FindValueResult> handler;

        public FindValueFuture(EntityKey entityKey, DHTTask<FindValueResult> handler) {
            super(FindValueManager.this.context, handler);
            this.entityKey = entityKey;
            this.handler = handler;
        }

        @Override
        protected void done() {
            FindValueManager.this.futureMap.remove(this.entityKey);
        }

        public String toString() {
            return "FindValueFuture: " + this.entityKey + ", " + this.handler;
        }
    }
}

