/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.io;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.KUID;
import org.limewire.mojito.handler.ResponseHandler;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.FindNodeRequest;
import org.limewire.mojito.messages.FindNodeResponse;
import org.limewire.mojito.messages.FindValueRequest;
import org.limewire.mojito.messages.FindValueResponse;
import org.limewire.mojito.messages.MessageID;
import org.limewire.mojito.messages.PingRequest;
import org.limewire.mojito.messages.PingResponse;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.ResponseMessage;
import org.limewire.mojito.messages.StatsRequest;
import org.limewire.mojito.messages.StatsResponse;
import org.limewire.mojito.messages.StoreRequest;
import org.limewire.mojito.messages.StoreResponse;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.util.ContactUtils;

public class Tag {
    private static final Log LOG = LogFactory.getLog(Tag.class);
    private final KUID nodeId;
    private final SocketAddress dst;
    private final DHTMessage message;
    private ByteBuffer data;
    private int size = -1;
    private final ResponseHandler responseHandler;
    private long sent = -1L;
    private long timeout = -1L;

    Tag(Contact contact, ResponseMessage message) {
        this.nodeId = contact.getNodeID();
        this.dst = contact.getContactAddress();
        this.message = message;
        this.responseHandler = null;
    }

    Tag(SocketAddress dst, RequestMessage message, ResponseHandler handler) {
        this(null, dst, message, handler, -1L);
    }

    Tag(Contact contact, RequestMessage message, ResponseHandler responseHandler) {
        this(contact.getNodeID(), contact.getContactAddress(), message, responseHandler, contact.getAdaptativeTimeout());
    }

    Tag(KUID nodeId, SocketAddress dst, RequestMessage message, ResponseHandler responseHandler) {
        this(nodeId, dst, message, responseHandler, -1L);
    }

    Tag(KUID nodeId, SocketAddress dst, RequestMessage message, ResponseHandler responseHandler, long timeout) {
        this.nodeId = nodeId;
        this.dst = dst;
        this.message = message;
        this.responseHandler = responseHandler;
        this.timeout = timeout;
    }

    public boolean isRequest() {
        return this.responseHandler != null && this.message instanceof RequestMessage;
    }

    public int getSize() {
        if (this.size < 0) {
            throw new IllegalStateException("Data is not set and the size is unknown");
        }
        return this.size;
    }

    public MessageID getMessageID() {
        return this.message.getMessageID();
    }

    public KUID getNodeID() {
        return this.nodeId;
    }

    public SocketAddress getSocketAddress() {
        return this.dst;
    }

    public DHTMessage getMessage() {
        return this.message;
    }

    public void setData(ByteBuffer data) {
        this.size = data.remaining();
        this.data = data;
    }

    public ByteBuffer getData() {
        if (this.data == null) {
            throw new IllegalStateException("Data is null");
        }
        return this.data;
    }

    public Receipt receipt() {
        this.sent = System.currentTimeMillis();
        this.data = null;
        return this.getReceipt();
    }

    private Receipt getReceipt() throws IllegalStateException {
        if (this.sent < 0L) {
            throw new IllegalStateException("Message has not been sent yet!");
        }
        if (this.isRequest()) {
            return new Receipt();
        }
        return null;
    }

    public void handleError(IOException e) {
        if (this.responseHandler != null) {
            this.responseHandler.handleError(this.nodeId, this.dst, (RequestMessage)this.message, e);
        }
    }

    public boolean isCancelled() {
        if (this.responseHandler != null) {
            return this.responseHandler.isCancelled();
        }
        return false;
    }

    public String toString() {
        return "Tag for " + this.message.toString() + " going to id " + this.getNodeID() + " dest: " + this.dst;
    }

    public class Receipt {
        private long received = -1L;

        private Receipt() {
        }

        public KUID getNodeID() {
            return Tag.this.getNodeID();
        }

        public SocketAddress getSocketAddress() {
            return Tag.this.getSocketAddress();
        }

        public MessageID getMessageID() {
            return Tag.this.getMessageID();
        }

        public RequestMessage getRequestMessage() {
            return (RequestMessage)Tag.this.getMessage();
        }

        public int getSentMessageSize() {
            return Tag.this.getSize();
        }

        public void received() {
            this.received = System.currentTimeMillis();
        }

        public long time() {
            if (this.received < 0L) {
                throw new IllegalStateException("The RTT is unknown as we have not received a response yet");
            }
            return this.received - Tag.this.sent;
        }

        private long elapsedTime() {
            return System.currentTimeMillis() - Tag.this.sent;
        }

        public boolean timeout() {
            long elapsed = this.elapsedTime();
            if (Tag.this.timeout < 0L) {
                long t = Tag.this.responseHandler.getTimeout();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Default timeout: " + t + "ms for " + ContactUtils.toString(Tag.this.nodeId, Tag.this.dst));
                }
                return elapsed >= t;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Timeout: " + Tag.this.timeout + "ms for " + ContactUtils.toString(Tag.this.nodeId, Tag.this.dst));
            }
            return elapsed >= Tag.this.timeout;
        }

        private boolean compareNodeID(ResponseMessage response) {
            if (Tag.this.nodeId == null) {
                return Tag.this.message instanceof PingRequest || Tag.this.message instanceof StatsRequest;
            }
            Contact node = response.getContact();
            return Tag.this.nodeId.equals(node.getNodeID());
        }

        private boolean compareAddresses(ResponseMessage response) {
            Contact node = response.getContact();
            InetAddress dstAddr = ((InetSocketAddress)Tag.this.dst).getAddress();
            InetAddress srcAddr = ((InetSocketAddress)node.getContactAddress()).getAddress();
            return dstAddr.equals(srcAddr);
        }

        private boolean compareResponseType(ResponseMessage response) {
            if (Tag.this.message instanceof PingRequest) {
                return response instanceof PingResponse;
            }
            if (Tag.this.message instanceof FindNodeRequest) {
                return response instanceof FindNodeResponse;
            }
            if (Tag.this.message instanceof FindValueRequest) {
                return response instanceof FindNodeResponse || response instanceof FindValueResponse;
            }
            if (Tag.this.message instanceof StoreRequest) {
                return response instanceof StoreResponse;
            }
            if (Tag.this.message instanceof StatsRequest) {
                return response instanceof StatsResponse;
            }
            return false;
        }

        public boolean sanityCheck(ResponseMessage response) {
            return this.compareNodeID(response) && this.compareAddresses(response) && this.compareResponseType(response);
        }

        public ResponseHandler getResponseHandler() {
            return Tag.this.responseHandler;
        }

        public void handleError(IOException e) {
            if (Tag.this.responseHandler != null) {
                Tag.this.responseHandler.handleError(Tag.this.nodeId, Tag.this.dst, (RequestMessage)Tag.this.message, e);
            }
        }

        public void handleTick() {
            if (Tag.this.responseHandler != null) {
                Tag.this.responseHandler.handleTick();
            }
        }

        public boolean isCancelled() {
            return Tag.this.isCancelled();
        }
    }
}

