/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler.response;

import java.io.IOException;
import java.math.BigInteger;
import java.net.SocketAddress;
import java.net.SocketException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.exceptions.DHTBackendException;
import org.limewire.mojito.exceptions.DHTBadResponseException;
import org.limewire.mojito.exceptions.DHTException;
import org.limewire.mojito.handler.response.AbstractResponseHandler;
import org.limewire.mojito.messages.PingResponse;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.ResponseMessage;
import org.limewire.mojito.result.PingResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.settings.PingSettings;
import org.limewire.mojito.util.ContactUtils;

public class PingResponseHandler
extends AbstractResponseHandler<PingResult> {
    private static final Log LOG = LogFactory.getLog(PingResponseHandler.class);
    private int parallelism;
    private int maxParallelPingFailures;
    private final Contact sender;
    private int active = 0;
    private int failures = 0;
    private final PingIterator pinger;

    public PingResponseHandler(Context context, PingIterator pinger) {
        this(context, null, pinger);
    }

    public PingResponseHandler(Context context, Contact sender, PingIterator pinger) {
        super(context);
        this.sender = sender;
        this.pinger = pinger;
        this.setParallelism(-1);
        this.setMaxParallelPingFailures(-1);
    }

    public void setParallelism(int parallelism) {
        if (parallelism < 0) {
            this.parallelism = PingSettings.PARALLEL_PINGS.getValue();
        } else if (parallelism > 0) {
            this.parallelism = parallelism;
        } else {
            throw new IllegalArgumentException("parallelism=" + parallelism);
        }
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setMaxParallelPingFailures(int maxParallelPingFailures) {
        this.maxParallelPingFailures = maxParallelPingFailures < 0 ? PingSettings.MAX_PARALLEL_PING_FAILURES.getValue() : maxParallelPingFailures;
    }

    public int getMaxParallelPingFailures() {
        return this.maxParallelPingFailures;
    }

    @Override
    protected void start() throws DHTException {
        if (!this.pinger.hasNext()) {
            throw new DHTException("No hosts to ping");
        }
        try {
            this.pingNextAndThrowIfDone(new DHTException("All SocketAddresses were invalid and there are no Hosts left to Ping: " + this.context.getLocalNode() + "; " + this.pinger));
        }
        catch (IOException e) {
            throw new DHTException(e);
        }
    }

    @Override
    protected void response(ResponseMessage message, long time) throws IOException {
        this.decrementActive();
        PingResponse response = (PingResponse)message;
        Contact node = response.getContact();
        SocketAddress externalAddress = response.getExternalAddress();
        BigInteger estimatedSize = response.getEstimatedSize();
        if (node.getContactAddress().equals(externalAddress)) {
            this.pingNextAndThrowIfDone(new DHTBadResponseException(node + " is trying to set our external address to its address!"));
            return;
        }
        if (this.context.isLocalNodeID(node.getNodeID())) {
            if (this.sender == null) {
                this.pingNextAndThrowIfDone(new DHTBadResponseException(node + " is trying to spoof our Node ID"));
            } else {
                this.setReturnValue(new PingResult(node, externalAddress, estimatedSize, time));
            }
            return;
        }
        this.context.setExternalAddress(externalAddress);
        this.context.addEstimatedRemoteSize(estimatedSize);
        this.setReturnValue(new PingResult(node, externalAddress, estimatedSize, time));
    }

    @Override
    protected void timeout(KUID nodeId, SocketAddress dst, RequestMessage message, long time) throws IOException {
        this.decrementActive();
        this.incrementFailures();
        if (LOG.isInfoEnabled()) {
            LOG.info("Timeout: " + ContactUtils.toString(nodeId, dst));
        }
        if (this.giveUp()) {
            if (!this.hasActive()) {
                this.fireTimeoutException(nodeId, dst, message, time);
            }
        } else {
            this.pingNextAndThrowIfDone(this.createTimeoutException(nodeId, dst, message, time));
        }
    }

    @Override
    protected void error(KUID nodeId, SocketAddress dst, RequestMessage message, IOException e) {
        this.decrementActive();
        this.incrementFailures();
        if (e instanceof SocketException && !this.giveUp()) {
            try {
                this.timeout(nodeId, dst, message, -1L);
            }
            catch (IOException err) {
                LOG.error("IOException", err);
                if (!this.pinger.hasNext()) {
                    this.setException(new DHTException(err));
                }
            }
        } else {
            this.setException(new DHTBackendException(nodeId, dst, message, e));
        }
    }

    private void pingNextAndThrowIfDone(DHTException e) throws IOException {
        while (this.pinger.hasNext() && this.canMore()) {
            if (!this.pinger.pingNext(this.context, this)) continue;
            this.incrementActive();
        }
        if (!this.hasActive()) {
            this.setException(e);
        }
    }

    private void decrementActive() {
        --this.active;
    }

    private void incrementActive() {
        ++this.active;
    }

    private void incrementFailures() {
        ++this.failures;
    }

    private boolean canMore() {
        return this.active < this.getParallelism();
    }

    private boolean hasActive() {
        return this.active > 0;
    }

    private boolean giveUp() {
        return !this.pinger.hasNext() || this.failures >= this.getMaxParallelPingFailures();
    }

    public static interface PingIterator {
        public boolean hasNext();

        public boolean pingNext(Context var1, PingResponseHandler var2) throws IOException;
    }
}

