/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler.response;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.handler.response.LookupResponseHandler;
import org.limewire.mojito.messages.FindNodeResponse;
import org.limewire.mojito.messages.LookupRequest;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.ResponseMessage;
import org.limewire.mojito.result.FindNodeResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.settings.LookupSettings;
import org.limewire.mojito.statistics.FindNodeLookupStatisticContainer;
import org.limewire.security.SecurityToken;

public class FindNodeResponseHandler
extends LookupResponseHandler<FindNodeResult> {
    private FindNodeLookupStatisticContainer lookupStat;

    public FindNodeResponseHandler(Context context, KUID lookupId) {
        super(context, lookupId);
        this.init();
    }

    public FindNodeResponseHandler(Context context, Contact forcedContact, KUID lookupId) {
        super(context, lookupId);
        this.addForcedContact(forcedContact);
        this.init();
    }

    public FindNodeResponseHandler(Context context, KUID lookupId, int resultSetSize) {
        super(context, lookupId);
        this.setResultSetSize(resultSetSize);
        this.init();
    }

    public FindNodeResponseHandler(Context context, Contact forcedContact, KUID lookupId, int resultSetSize) {
        super(context, lookupId);
        this.addForcedContact(forcedContact);
        this.setResultSetSize(resultSetSize);
        this.init();
    }

    private void init() {
        this.lookupStat = new FindNodeLookupStatisticContainer(this.context, this.getLookupID());
    }

    @Override
    protected void response(ResponseMessage message, long time) throws IOException {
        super.response(message, time);
        this.lookupStat.addReply();
    }

    @Override
    protected void timeout(KUID nodeId, SocketAddress dst, RequestMessage message, long time) throws IOException {
        super.timeout(nodeId, dst, message, time);
        this.lookupStat.addTimeout();
    }

    @Override
    protected boolean lookup(Contact node) throws IOException {
        if (super.lookup(node)) {
            this.lookupStat.addRequest();
            return true;
        }
        return false;
    }

    @Override
    protected void finishLookup() {
        long time = this.getElapsedTime();
        int routeTableFailureCount = this.getRouteTableFailureCount();
        int currentHop = this.getCurrentHop();
        this.lookupStat.setHops(currentHop, false);
        this.lookupStat.setTime((int)time, false);
        Map<Contact, SecurityToken> path = this.getPath();
        Collection<Contact> collisions = this.getCollisions();
        Set<KUID> queried = this.getQueried();
        FindNodeResult result = new FindNodeResult(this.getLookupID(), path, collisions, queried, time, currentHop, routeTableFailureCount);
        this.context.updateEstimatedSize(path.keySet());
        this.setReturnValue(result);
    }

    public Collection<Contact> getCollisions() {
        return this.collisions;
    }

    @Override
    protected int getDefaultParallelism() {
        return LookupSettings.FIND_NODE_PARALLEL_LOOKUPS.getValue();
    }

    @Override
    protected boolean isTimeout(long time) {
        long lookupTimeout = LookupSettings.FIND_NODE_LOOKUP_TIMEOUT.getValue();
        return lookupTimeout > 0L && time >= lookupTimeout;
    }

    @Override
    protected LookupRequest createLookupRequest(Contact node) {
        return this.context.getMessageHelper().createFindNodeRequest(node.getContactAddress(), this.lookupId);
    }

    @Override
    protected boolean nextStep(ResponseMessage message) throws IOException {
        if (!(message instanceof FindNodeResponse)) {
            throw new IllegalArgumentException("this is find node handler");
        }
        return this.handleNodeResponse((FindNodeResponse)message);
    }
}

