/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.lws.server;

import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.nio.entity.ConsumingNHttpEntity;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.NHttpResponseTrigger;
import org.apache.http.protocol.HttpContext;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.lws.server.LWSConnectionListener;
import org.limewire.lws.server.LWSDispatcher;
import org.limewire.lws.server.LWSReceivesCommandsFromDispatcher;
import org.limewire.lws.server.LWSServerUtil;
import org.limewire.lws.server.StringCallback;

public abstract class LWSDispatcherSupport
implements LWSDispatcher {
    private static final Log LOG = LogFactory.getLog(LWSDispatcherSupport.class);
    private final Map<String, Handler> names2handlers = new HashMap<String, Handler>();
    private LWSReceivesCommandsFromDispatcher commandReceiver;
    private final Executor handlerExecutor = ExecutorsHelper.newProcessingQueue("lws-handlers");
    public static final byte[] PING_BYTES = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 1, 0, 0, 0, 1, 8, 6, 0, 0, 0, 31, 21, -60, -119, 0, 0, 0, 1, 115, 82, 71, 66, 0, -82, -50, 28, -23, 0, 0, 0, 4, 103, 65, 77, 65, 0, 0, -79, -113, 11, -4, 97, 5, 0, 0, 0, 32, 99, 72, 82, 77, 0, 0, 122, 38, 0, 0, -128, -124, 0, 0, -6, 0, 0, 0, -128, -24, 0, 0, 117, 48, 0, 0, -22, 96, 0, 0, 58, -104, 0, 0, 23, 112, -100, -70, 81, 60, 0, 0, 0, 24, 116, 69, 88, 116, 83, 111, 102, 116, 119, 97, 114, 101, 0, 80, 97, 105, 110, 116, 46, 78, 69, 84, 32, 118, 51, 46, 49, 48, 114, -78, 37, -110, 0, 0, 0, 11, 73, 68, 65, 84, 24, 87, 99, -8, 15, 4, 0, 9, -5, 3, -3, 43, -43, 8, 69, 0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};

    public LWSDispatcherSupport() {
        Handler[] hs = this.createHandlers();
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating " + hs.length + " handler(s)...");
        }
        for (Handler h : hs) {
            this.names2handlers.put(h.name().toLowerCase(Locale.US), h);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug(" - " + h.name());
        }
    }

    protected abstract boolean isAuthenticated();

    protected abstract String getCommand(String var1);

    protected abstract Map<String, String> getArgs(String var1);

    @Override
    public ConsumingNHttpEntity entityRequest(HttpEntityEnclosingRequest request, HttpContext context) throws HttpException, IOException {
        return null;
    }

    @Override
    public final void handle(HttpRequest httpReq, final HttpResponse response, final NHttpResponseTrigger trigger, HttpContext c) throws HttpException, IOException {
        String request = httpReq.getRequestLine().getUri();
        String command = this.getCommand(request);
        this.note("Have command {0} ", command);
        if (this.isAuthenticated() && command.equals("Ping")) {
            this.note("Handling PING", new Object[0]);
            this.handlerExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    response.setEntity(new ByteArrayEntity(PING_BYTES));
                    trigger.submitResponse(response);
                }
            });
            this.notifyConnectionListeners(true);
            return;
        }
        final Handler h = this.names2handlers.get(command.toLowerCase(Locale.US));
        if (h == null) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Couldn't create a handler for " + command);
            }
            String str = LWSDispatcherSupport.report("unknown.command");
            response.setEntity(new NStringEntity(str));
            trigger.submitResponse(response);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("have handler: " + h.name());
        }
        final Map<String, String> args = this.getArgs(request);
        this.note("Have args {0} ", args);
        this.handlerExecutor.execute(new Runnable(){

            @Override
            public void run() {
                h.handle(args, new StringCallback(){

                    @Override
                    public void process(String input) {
                        try {
                            LWSDispatcherSupport.this.note("Have response {0}", input);
                            response.setEntity(new NStringEntity(input));
                            trigger.submitResponse(response);
                        }
                        catch (UnsupportedEncodingException e) {
                            trigger.handleException(e);
                        }
                    }
                });
            }
        });
    }

    @Override
    public final boolean addConnectionListener(LWSConnectionListener lis) {
        return this.getCommandReceiver().addConnectionListener(lis);
    }

    @Override
    public final boolean removeConnectionListener(LWSConnectionListener lis) {
        return this.getCommandReceiver().removeConnectionListener(lis);
    }

    @Override
    public final void notifyConnectionListeners(boolean isConnected) {
        this.getCommandReceiver().setConnected(isConnected);
    }

    protected abstract Handler[] createHandlers();

    public final void setCommandReceiver(LWSReceivesCommandsFromDispatcher commandReceiver) {
        this.commandReceiver = commandReceiver;
    }

    final LWSReceivesCommandsFromDispatcher getCommandReceiver() {
        return this.commandReceiver;
    }

    public final void handle(String request, PrintStream out, StringCallback callback) {
        String req = this.getCommand(request);
        if (this.isAuthenticated() && req.equals("Ping")) {
            this.note("Handling PING", new Object[0]);
            callback.process(new String(PING_BYTES));
            this.notifyConnectionListeners(true);
            return;
        }
        Handler h = this.names2handlers.get(req.toLowerCase(Locale.US));
        if (h == null) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Couldn't create a handler for " + req);
            }
            callback.process(LWSDispatcherSupport.report("unknown.command"));
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("have handler: " + h.name());
        }
        Map<String, String> args = this.getArgs(request);
        h.handle(args, callback);
    }

    final void note(String pattern, Object ... os) {
        if (LOG.isDebugEnabled()) {
            LOG.info(MessageFormat.format(pattern, os));
        }
    }

    public static final String report(String error) {
        return LWSDispatcherSupport.wrapCallback("error", LWSServerUtil.wrapError(error));
    }

    public static final String wrapCallback(String callback, String msg) {
        if (LWSServerUtil.isEmpty(callback)) {
            return msg;
        }
        char q = '\'';
        String s = Constants.CALLBACK_QUOTE_STRING;
        return callback + "(" + q + (msg == null ? "" : msg.replace(s, "\\" + s)) + q + ")";
    }

    public static interface Constants {
        public static final int KEY_LENGTH = 10;
        public static final String NEWLINE = "\r\n";
        public static final char CALLBACK_QUOTE = '\'';
        public static final String CALLBACK_QUOTE_STRING = String.valueOf('\'');
        public static final String ERROR_CALLBACK = "error";
        public static final String ARGUMENT_SEPARATOR = "%26";
    }

    public static interface Responses {
        public static final String OK = "ok";
        public static final String NO_DISPATCHEE = "no.dispatcher";
        public static final String UNKNOWN_COMMAND = "unknown.command";
    }

    public static interface ErrorCodes {
        public static final String INVALID_PUBLIC_KEY = "invalid.public.key";
        public static final String INVALID_PRIVATE_KEY = "invalid.private.key";
        public static final String INVALID_SHARED_KEY = "invalid.shared.key";
        public static final String INVALID_PUBLIC_KEY_OR_IP = "invalid.public.key.or.ip.address";
        public static final String MISSING_CALLBACK_PARAMETER = "missing.callback.parameter";
        public static final String UNKNOWN_COMMAND = "unknown.command";
        public static final String UNITIALIZED_PRIVATE_KEY = "uninitialized.private.key";
        public static final String MISSING_PRIVATE_KEY_PARAMETER = "missing.private.parameter";
        public static final String UNITIALIZED_SHARED_KEY = "uninitialized.shared.key";
        public static final String MISSING_SHARED_KEY_PARAMETER = "missing.shared.parameter";
        public static final String MISSING_PUBLIC_KEY_PARAMETER = "missing.public.parameter";
        public static final String MISSING_COMMAND_PARAMETER = "missing.command.parameter";
        public static final String MISSING_IP_PARAMETER = "missing.ip.parameter";
        public static final String MISSING_PARAMETER = "missing.parameter";
    }

    public static interface Parameters {
        public static final String CALLBACK = "callback";
        public static final String PRIVATE = "private";
        public static final String PUBLIC = "public";
        public static final String SHARED = "shared";
        public static final String COMMAND = "command";
        public static final String MSG = "msg";
        public static final String URL = "url";
        public static final String IP = "ip";
    }

    public static interface Commands {
        public static final String START_COM = "StartCom";
        public static final String STORE_KEY = "StoreKey";
        public static final String GIVE_KEY = "GiveKey";
        public static final String DETATCH = "Detatch";
        public static final String AUTHENTICATE = "Authenticate";
        public static final String PING = "Ping";
        public static final String MSG = "Msg";
    }

    static interface OpensSocket {
        public Socket open(String var1, int var2) throws IOException;
    }

    protected abstract class HandlerWithCallback
    extends AbstractHandler {
        protected HandlerWithCallback() {
        }

        @Override
        public final void handle(Map<String, String> args, final StringCallback cb) {
            final String callback = args.get("callback");
            if (callback == null) {
                cb.process(this.report("missing.callback.parameter"));
                return;
            }
            this.handleRest(args, new StringCallback(){

                @Override
                public void process(String res) {
                    String str = LWSServerUtil.isError(res) ? LWSDispatcherSupport.wrapCallback("error", res) : LWSDispatcherSupport.wrapCallback(callback, res);
                    cb.process(str);
                }
            });
        }

        protected abstract void handleRest(Map<String, String> var1, StringCallback var2);

        @Override
        protected final String report(String error) {
            return LWSServerUtil.wrapError(error);
        }
    }

    protected static abstract class AbstractHandler
    extends HasName
    implements Handler {
        protected AbstractHandler(String name) {
            super(name);
        }

        protected AbstractHandler() {
        }

        protected String report(String msg) {
            return LWSDispatcherSupport.report(msg);
        }
    }

    protected static interface Handler {
        public void handle(Map<String, String> var1, StringCallback var2);

        public String name();
    }

    static abstract class HasName {
        private final String name;

        public HasName(String name) {
            this.name = name;
        }

        public HasName() {
            String n = this.getClass().getName();
            int ilast = n.lastIndexOf(".");
            if (ilast != -1) {
                n = n.substring(ilast + 1);
            }
            if ((ilast = n.lastIndexOf("$")) != -1) {
                n = n.substring(ilast + 1);
            }
            this.name = n;
        }

        public final String name() {
            return this.name;
        }
    }
}

