/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.libtorrent;

import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.ptr.IntByReference;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.limewire.bittorrent.TorrentException;
import org.limewire.bittorrent.TorrentFileEntry;
import org.limewire.bittorrent.TorrentInfo;
import org.limewire.bittorrent.TorrentManagerSettings;
import org.limewire.bittorrent.TorrentPiecesInfo;
import org.limewire.bittorrent.TorrentStatus;
import org.limewire.inject.LazySingleton;
import org.limewire.libtorrent.IpFilterCallback;
import org.limewire.libtorrent.LibTorrent;
import org.limewire.libtorrent.LibTorrentAlert;
import org.limewire.libtorrent.LibTorrentAnnounceEntry;
import org.limewire.libtorrent.LibTorrentFileEntry;
import org.limewire.libtorrent.LibTorrentInfo;
import org.limewire.libtorrent.LibTorrentPeer;
import org.limewire.libtorrent.LibTorrentPiecesInfo;
import org.limewire.libtorrent.LibTorrentPiecesInfoContainer;
import org.limewire.libtorrent.LibTorrentProxySetting;
import org.limewire.libtorrent.LibTorrentSettings;
import org.limewire.libtorrent.LibTorrentStatus;
import org.limewire.libtorrent.TorrentInfoImpl;
import org.limewire.libtorrent.WrapperStatus;
import org.limewire.libtorrent.callback.AlertCallback;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.ExceptionUtils;
import org.limewire.util.OSUtils;

@LazySingleton
class LibTorrentWrapper {
    private static final Log LOG = LogFactory.getLog(LibTorrentWrapper.class);
    private final AtomicBoolean loaded = new AtomicBoolean(false);
    private LibTorrent libTorrent;

    LibTorrentWrapper() {
    }

    void initialize(TorrentManagerSettings torrentSettings) {
        block2: {
            String torrentWrapperLibName = LibTorrentWrapper.getLibraryName();
            try {
                this.libTorrent = (LibTorrent)Native.loadLibrary(torrentWrapperLibName, LibTorrent.class);
                NativeLibrary lib = NativeLibrary.getInstance(torrentWrapperLibName);
                this.validate(lib);
                this.init(torrentSettings);
                this.loaded.set(true);
            }
            catch (Throwable e) {
                LOG.error("Failure loading the libtorrent libraries.", e);
                if (!torrentSettings.isReportingLibraryLoadFailture()) break block2;
                ExceptionUtils.reportOrReturn(e);
            }
        }
    }

    private static String getLibraryName() {
        String arch;
        if (OSUtils.isLinux() && ((arch = OSUtils.getOSArch()).equals("x86_64") || arch.equals("amd64"))) {
            return "torrent-wrapper64";
        }
        return "torrent-wrapper";
    }

    private void validate(NativeLibrary lib) {
        for (Method method : LibTorrent.class.getMethods()) {
            lib.getFunction(method.getName());
        }
    }

    public boolean isLoaded() {
        return this.loaded.get();
    }

    private void init(TorrentManagerSettings torrentSettings) {
        LOG.debugf("before init", new Object[0]);
        this.catchWrapperException(this.libTorrent.init(new LibTorrentSettings(torrentSettings)));
        LOG.debugf("after init", new Object[0]);
    }

    public void add_torrent(String sha1, String trackerURI, String torrentPath, String savePath, String fastResumePath) {
        LOG.debugf("before add_torrent: {0}", (Object)sha1);
        this.catchWrapperException(this.libTorrent.add_torrent(sha1, trackerURI, new WString(torrentPath), new WString(savePath), new WString(fastResumePath)));
        LOG.debugf("after add_torrent: {0}", (Object)sha1);
    }

    public void freeze_and_save_all_fast_resume_data(AlertCallback alertCallback) {
        LOG.debug("before get_alerts");
        this.catchWrapperException(this.libTorrent.freeze_and_save_all_fast_resume_data(alertCallback));
        LOG.debug("after get_alerts");
    }

    public void get_alerts(AlertCallback alertCallback) {
        LOG.debug("before get_alerts");
        this.catchWrapperException(this.libTorrent.get_alerts(alertCallback));
        LOG.debug("after get_alerts");
    }

    public void set_ip_filter(IpFilterCallback ipFilterCallback) {
        LOG.debug("before set_ip_filter");
        this.catchWrapperException(this.libTorrent.set_ip_filter(ipFilterCallback));
        LOG.debug("after set_ip_filter");
    }

    public void pause_torrent(String id) {
        LOG.debugf("before pause_torrent: {0}", (Object)id);
        this.catchWrapperException(this.libTorrent.pause_torrent(id));
        LOG.debugf("after pause_torrent: {0}", (Object)id);
    }

    public void resume_torrent(String id) {
        LOG.debugf("before resume_torrent: {0}", (Object)id);
        this.catchWrapperException(this.libTorrent.resume_torrent(id));
        LOG.debugf("after resume_torrent: {0}", (Object)id);
    }

    public void scrape_tracker(String id) {
        LOG.debugf("before scrape_tracker: {0}", (Object)id);
        this.catchWrapperException(this.libTorrent.scrape_tracker(id));
        LOG.debugf("after scrape_tracker: {0}", (Object)id);
    }

    public void force_reannounce(String id) {
        LOG.debugf("before force_reannounce: {0}", (Object)id);
        this.catchWrapperException(this.libTorrent.force_reannounce(id));
        LOG.debugf("after force_reannounce: {0}", (Object)id);
    }

    public void get_torrent_status(String id, TorrentStatus status) {
        LOG.debugf("before get_torrent_status: {0}", (Object)id);
        this.catchWrapperException(this.libTorrent.get_torrent_status(id, status));
        LOG.debugf("after get_torrent_status: {0}", (Object)id);
    }

    public void remove_torrent(String id) {
        LOG.debugf("before remove_torrent: {0}", (Object)id);
        this.catchWrapperException(this.libTorrent.remove_torrent(id));
        LOG.debugf("after remove_torrent: {0}", (Object)id);
    }

    public LibTorrentPeer[] get_peers(String id) {
        LOG.debugf("before get_num_peers: {0}", (Object)id);
        IntByReference numPeersReference = new IntByReference();
        this.catchWrapperException(this.libTorrent.get_num_peers(id, numPeersReference));
        LOG.debugf("after get_num_peers: {0} - {1}", (Object)id, (Object)numPeersReference);
        int numPeers = numPeersReference.getValue();
        if (numPeers == 0) {
            return new LibTorrentPeer[0];
        }
        LibTorrentPeer[] torrentPeers = new LibTorrentPeer[numPeers];
        Pointer[] torrentPeersPointers = new Pointer[numPeers];
        for (int i = 0; i < torrentPeersPointers.length; ++i) {
            LibTorrentPeer torrentPeer;
            torrentPeers[i] = torrentPeer = new LibTorrentPeer();
            torrentPeersPointers[i] = torrentPeer.getPointer();
        }
        LOG.debugf("before get_peers: {0}", (Object)id);
        this.catchWrapperException(this.libTorrent.get_peers(id, torrentPeersPointers, torrentPeersPointers.length));
        ArrayList<LibTorrentPeer> remainingTorrentPeers = new ArrayList<LibTorrentPeer>(torrentPeers.length);
        for (int i = 0; i < torrentPeers.length; ++i) {
            torrentPeers[i].read();
            if (torrentPeers[i].getIPAddress() == null || torrentPeers[i].getIPAddress().isEmpty()) continue;
            remainingTorrentPeers.add(torrentPeers[i]);
        }
        LOG.debugf("before free_peers: {0}", (Object)id);
        this.free_peers(torrentPeersPointers);
        LOG.debugf("after free_peers: {0}", (Object)id);
        LOG.debugf("after get_peers: {0}", (Object)id);
        return remainingTorrentPeers.toArray(new LibTorrentPeer[remainingTorrentPeers.size()]);
    }

    private void free_peers(Pointer[] torrentPeersPointers) {
        this.catchWrapperException(this.libTorrent.free_peers(torrentPeersPointers, torrentPeersPointers.length));
    }

    public void signal_fast_resume_data_request(String id) {
        LOG.debugf("before print signal_fast_resume_data_request: {0}", (Object)id);
        this.catchWrapperException(this.libTorrent.signal_fast_resume_data_request(id));
        LOG.debugf("after print signal_fast_resume_data_request: {0}", (Object)id);
    }

    public void clear_error_and_retry(String id) {
        LOG.debugf("before print clear_error_and_retry: {0}", (Object)id);
        this.catchWrapperException(this.libTorrent.clear_error_and_retry(id));
        LOG.debugf("after print clear_error_and_retry: {0}", (Object)id);
    }

    public void move_torrent(String id, String absolutePath) {
        LOG.debugf("before move_torrent: {0} - {1}", (Object)id, (Object)absolutePath);
        this.catchWrapperException(this.libTorrent.move_torrent(id, new WString(absolutePath)));
        LOG.debugf("after move_torrent: {0} - {1}", (Object)id, (Object)absolutePath);
    }

    public void abort_torrents() {
        LOG.debug("before abort");
        this.catchWrapperException(this.libTorrent.abort_torrents());
        LOG.debug("after abort");
    }

    public void free_torrent_status(LibTorrentStatus status) {
        LOG.debugf("before free_torrent_status: {0}", (Object)status);
        this.catchWrapperException(this.libTorrent.free_torrent_status(status.getPointer()));
        LOG.debugf("after free_torrent_status: {0}", (Object)status);
    }

    private void catchWrapperException(WrapperStatus status) {
        if (status != null) {
            throw new TorrentException(status.message, status.type);
        }
    }

    public void update_settings(TorrentManagerSettings torrentSettings) {
        LOG.debugf("before update_settings: {0}", (Object)torrentSettings);
        this.catchWrapperException(this.libTorrent.update_settings(new LibTorrentSettings(torrentSettings)));
        LOG.debugf("after update_settings: {0}", (Object)torrentSettings);
    }

    public void start_dht() {
        this.start_dht(null);
    }

    public void start_dht(File dhtStateFile) {
        LOG.debugf("before start_dht", new Object[0]);
        WString dhtStateFilePath = dhtStateFile != null ? new WString(dhtStateFile.getAbsolutePath()) : null;
        this.catchWrapperException(this.libTorrent.start_dht(dhtStateFilePath));
        LOG.debugf("after start_dht", new Object[0]);
    }

    public void stop_dht() {
        LOG.debugf("before stop_dht", new Object[0]);
        this.catchWrapperException(this.libTorrent.stop_dht());
        LOG.debugf("after stop_dht", new Object[0]);
    }

    public void save_dht_state(File dhtStateFile) {
        LOG.debugf("before save_dht_state", new Object[0]);
        if (dhtStateFile != null) {
            dhtStateFile.getParentFile().mkdirs();
        }
        WString dhtStateFilePath = dhtStateFile != null ? new WString(dhtStateFile.getAbsolutePath()) : null;
        this.catchWrapperException(this.libTorrent.save_dht_state(dhtStateFilePath));
        LOG.debugf("after save_dht_state", new Object[0]);
    }

    public void add_dht_router(String address, int port) {
        LOG.debugf("before add_dht_router: address={0}, port={1}", (Object)address, (Object)port);
        this.catchWrapperException(this.libTorrent.add_dht_router(address, port));
        LOG.debugf("after add_dht_router: address={0}, port={1}", (Object)address, (Object)port);
    }

    public void add_dht_node(String address, int port) {
        LOG.debugf("before add_dht_node: address={0}, port={1}", (Object)address, (Object)port);
        this.catchWrapperException(this.libTorrent.add_dht_node(address, port));
        LOG.debugf("after add_dht_node: address={0}, port={1}", (Object)address, (Object)port);
    }

    public void start_upnp() {
        LOG.debugf("before start_upnp", new Object[0]);
        this.catchWrapperException(this.libTorrent.start_upnp());
        LOG.debugf("after start_upnp", new Object[0]);
    }

    public void stop_upnp() {
        LOG.debugf("before stop_upnp", new Object[0]);
        this.catchWrapperException(this.libTorrent.stop_upnp());
        LOG.debugf("after stop_upnp", new Object[0]);
    }

    public void start_lsd() {
        LOG.debugf("before start_lsd", new Object[0]);
        this.catchWrapperException(this.libTorrent.start_lsd());
        LOG.debugf("after start_lsd", new Object[0]);
    }

    public void stop_lsd() {
        LOG.debugf("before stop_lsd", new Object[0]);
        this.catchWrapperException(this.libTorrent.stop_lsd());
        LOG.debugf("after stop_lsd", new Object[0]);
    }

    public void start_natpmp() {
        LOG.debugf("before start_natpmp", new Object[0]);
        this.catchWrapperException(this.libTorrent.start_natpmp());
        LOG.debugf("after start_natpmp", new Object[0]);
    }

    public void stop_natpmp() {
        LOG.debugf("before stop_natpmp", new Object[0]);
        this.catchWrapperException(this.libTorrent.stop_natpmp());
        LOG.debugf("after stop_natpmp", new Object[0]);
    }

    public void set_seed_ratio(String id, float seed_ratio) {
        LOG.debugf("before set_seed_ratio", new Object[0]);
        this.catchWrapperException(this.libTorrent.set_seed_ratio(id, seed_ratio));
        LOG.debugf("after set_seed_ratio", new Object[0]);
    }

    public void set_file_priorities(String id, int[] priorities) {
        LOG.debugf("before set_file_priorities", new Object[0]);
        this.catchWrapperException(this.libTorrent.set_file_priorities(id, priorities, priorities.length));
        LOG.debugf("after set_file_priorities", new Object[0]);
    }

    public int get_num_files(String id) {
        LOG.debugf("before get_num_files", new Object[0]);
        IntByReference numFiles = new IntByReference();
        this.catchWrapperException(this.libTorrent.get_num_files(id, numFiles));
        LOG.debugf("after get_num_files", new Object[0]);
        return numFiles.getValue();
    }

    public LibTorrentFileEntry[] get_files(String id) {
        int i;
        LOG.debugf("before get_files", new Object[0]);
        int numFiles = this.get_num_files(id);
        LibTorrentFileEntry[] fileEntries = new LibTorrentFileEntry[numFiles];
        Pointer[] filePointers = new Pointer[numFiles];
        for (i = 0; i < fileEntries.length; ++i) {
            LibTorrentFileEntry fileEntry;
            fileEntries[i] = fileEntry = new LibTorrentFileEntry();
            filePointers[i] = fileEntry.getPointer();
        }
        this.catchWrapperException(this.libTorrent.get_files(id, filePointers));
        for (i = 0; i < fileEntries.length; ++i) {
            fileEntries[i].read();
        }
        LOG.debugf("after get_files", new Object[0]);
        return fileEntries;
    }

    public void set_auto_managed_torrent(String sha1, boolean auto_managed) {
        LOG.debugf("before set_auto_managed_torrent: {0} - {1}", (Object)sha1, (Object)auto_managed);
        this.catchWrapperException(this.libTorrent.set_auto_managed_torrent(sha1, auto_managed));
        LOG.debugf("after set_auto_managed_torrent: {0} - {1}", (Object)sha1, (Object)auto_managed);
    }

    public void set_file_priority(String sha1, int index, int priority) {
        LOG.debugf("before set_file_priority: {0} - index: {1} - priority: {2}", (Object)sha1, (Object)index, (Object)priority);
        this.catchWrapperException(this.libTorrent.set_file_priority(sha1, index, priority));
        LOG.debugf("after set_file_priority: {0} - index: {1} - priority: {2}", (Object)sha1, (Object)index, (Object)priority);
    }

    public boolean has_metadata(String id) {
        LOG.debugf("before has_metadata: {0}", (Object)id);
        IntByReference has_metadata = new IntByReference(0);
        this.catchWrapperException(this.libTorrent.has_metadata(id, has_metadata));
        LOG.debugf("after has_metadata: {0}", (Object)id);
        return has_metadata.getValue() != 0;
    }

    public boolean is_valid(String id) {
        LOG.debugf("before is_valid: {0}", (Object)id);
        IntByReference is_valid = new IntByReference(0);
        this.catchWrapperException(this.libTorrent.is_valid(id, is_valid));
        LOG.debugf("after is_valid: {0}", (Object)id);
        return is_valid.getValue() != 0;
    }

    public TorrentInfo get_torrent_info(String id) {
        LOG.debugf("before get_torrent_info: {0}", (Object)id);
        LibTorrentInfo info = new LibTorrentInfo();
        this.catchWrapperException(this.libTorrent.get_torrent_info(id, info));
        this.free_torrent_info(info);
        TorrentFileEntry[] files = this.get_files(id);
        LOG.debugf("after get_torrent_info: {0}", (Object)id);
        return new TorrentInfoImpl(info, files);
    }

    public void free_torrent_info(LibTorrentInfo info) {
        LOG.debugf("before free_torrent_info: {0}", (Object)info);
        this.catchWrapperException(this.libTorrent.free_torrent_info(info.getPointer()));
        LOG.debugf("after free_torrent_info: {0}", (Object)info);
    }

    public void save_fast_resume_data(LibTorrentAlert alert, String filePath) {
        LOG.debugf("before save_fast_resume_data: {0} - {1}", (Object)alert, (Object)filePath);
        this.catchWrapperException(this.libTorrent.save_fast_resume_data(alert, new WString(filePath)));
        LOG.debugf("after save_fast_resume_data: {0} - {1}", (Object)alert, (Object)filePath);
    }

    public void set_peer_proxy(LibTorrentProxySetting proxySetting) {
        LOG.debugf("before set_peer_proxy: {0}", (Object)proxySetting);
        this.catchWrapperException(this.libTorrent.set_peer_proxy(proxySetting));
        LOG.debugf("after set_peer_proxy: {0}", (Object)proxySetting);
    }

    public void set_dht_proxy(LibTorrentProxySetting proxySetting) {
        LOG.debugf("before set_dht_proxy: {0}", (Object)proxySetting);
        this.catchWrapperException(this.libTorrent.set_dht_proxy(proxySetting));
        LOG.debugf("after set_dht_proxy: {0}", (Object)proxySetting);
    }

    public void set_tracker_proxy(LibTorrentProxySetting proxySetting) {
        LOG.debugf("before set_tracker_proxy: {0}", (Object)proxySetting);
        this.catchWrapperException(this.libTorrent.set_tracker_proxy(proxySetting));
        LOG.debugf("after set_tracker_proxy: {0}", (Object)proxySetting);
    }

    public void set_web_seed_proxy(LibTorrentProxySetting proxySetting) {
        LOG.debugf("before set_web_seed_proxy: {0}", (Object)proxySetting);
        this.catchWrapperException(this.libTorrent.set_web_seed_proxy(proxySetting));
        LOG.debugf("after set_web_seed_proxy: {0}", (Object)proxySetting);
    }

    public TorrentPiecesInfo get_pieces_status(String sha1) {
        LibTorrentPiecesInfoContainer info = new LibTorrentPiecesInfoContainer();
        LOG.debugf("before get_pieces_status: {0}", (Object)sha1);
        this.catchWrapperException(this.libTorrent.get_pieces_status(sha1, info));
        LOG.debugf("after get_pieces_status: {0}", (Object)sha1);
        LibTorrentPiecesInfo exportInfo = new LibTorrentPiecesInfo(info);
        LOG.debugf("before free_pieces_info: {0}", (Object)sha1);
        this.catchWrapperException(this.libTorrent.free_pieces_info(info.getPointer()));
        LOG.debugf("after free_pieces_info: {0}", (Object)sha1);
        return exportInfo;
    }

    public void add_tracker(String sha1, String url, int tier) {
        LOG.debugf("before add_tracker: {0}", (Object)sha1);
        this.catchWrapperException(this.libTorrent.add_tracker(sha1, url, tier));
        LOG.debugf("after add_tracker: {0}", (Object)sha1);
    }

    public void remove_tracker(String sha1, String url, int tier) {
        LOG.debugf("before remove_tracker: {0}", (Object)sha1);
        this.catchWrapperException(this.libTorrent.remove_tracker(sha1, url, tier));
        LOG.debugf("after remove_tracker: {0}", (Object)sha1);
    }

    public LibTorrentAnnounceEntry[] get_trackers(String sha1) {
        int numTrackers = this.get_num_trackers(sha1);
        if (numTrackers == 0) {
            return new LibTorrentAnnounceEntry[0];
        }
        LibTorrentAnnounceEntry[] torrentTrackers = new LibTorrentAnnounceEntry[numTrackers];
        Pointer[] torrentTrackersPointers = new Pointer[numTrackers];
        for (int i = 0; i < torrentTrackersPointers.length; ++i) {
            LibTorrentAnnounceEntry torrentTracker;
            torrentTrackers[i] = torrentTracker = new LibTorrentAnnounceEntry();
            torrentTrackersPointers[i] = torrentTracker.getPointer();
        }
        LOG.debugf("before get_trackers: {0}", (Object)sha1);
        this.catchWrapperException(this.libTorrent.get_trackers(sha1, torrentTrackersPointers, numTrackers));
        LOG.debugf("after get_trackers: {0}", (Object)sha1);
        for (LibTorrentAnnounceEntry tracker : torrentTrackers) {
            tracker.read();
        }
        LOG.debugf("before free_trackers: {0}", (Object)sha1);
        this.free_trackers(torrentTrackersPointers);
        LOG.debugf("after free_trackers: {0}", (Object)sha1);
        return torrentTrackers;
    }

    private int get_num_trackers(String sha1) {
        IntByReference numTrackersReference = new IntByReference();
        LOG.debugf("before get_num_trackers: {0}", (Object)sha1);
        this.catchWrapperException(this.libTorrent.get_num_trackers(sha1, numTrackersReference));
        LOG.debugf("after get_num_trackers: {0}", (Object)sha1);
        return numTrackersReference.getValue();
    }

    private void free_trackers(Pointer[] torrentTrackerPointers) {
        this.catchWrapperException(this.libTorrent.free_trackers(torrentTrackerPointers, torrentTrackerPointers.length));
    }
}

