/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.libtorrent;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.limewire.bittorrent.BTDataImpl;
import org.limewire.bittorrent.TorrentParams;
import org.limewire.bittorrent.bencoding.Token;
import org.limewire.io.IOUtils;
import org.limewire.util.StringUtils;

public class LibTorrentParams
implements TorrentParams {
    private final File downloadFolder;
    private String name = null;
    private String sha1 = null;
    private String trackerURL = null;
    private File fastResumeFile = null;
    private File torrentFile = null;
    private File torrentDataFile = null;
    private Boolean isPrivate = null;
    private final AtomicBoolean filled = new AtomicBoolean(false);

    public LibTorrentParams(File downloadFolder, File torrentFile) {
        this.downloadFolder = downloadFolder;
        this.torrentFile = torrentFile;
    }

    public LibTorrentParams(File downloadFolder, String name, String sha1) {
        this.downloadFolder = downloadFolder;
        this.name = name;
        this.sha1 = sha1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getSha1() {
        return this.sha1;
    }

    @Override
    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    @Override
    public String getTrackerURL() {
        return this.trackerURL;
    }

    @Override
    public void setTrackerURL(String trackerURL) {
        this.trackerURL = trackerURL;
    }

    @Override
    public File getFastResumeFile() {
        return this.fastResumeFile;
    }

    @Override
    public void setFastResumeFile(File fastResumeFile) {
        this.fastResumeFile = fastResumeFile;
    }

    @Override
    public File getTorrentFile() {
        return this.torrentFile;
    }

    @Override
    public File getDownloadFolder() {
        return this.downloadFolder;
    }

    @Override
    public void setTorrentFile(File torrentFile) {
        this.filled.set(false);
        this.torrentFile = torrentFile;
    }

    @Override
    public File getTorrentDataFile() {
        return this.torrentDataFile;
    }

    @Override
    public void setTorrentDataFile(File torrentDataFile) {
        this.torrentDataFile = torrentDataFile;
    }

    @Override
    public Boolean getPrivate() {
        return this.isPrivate;
    }

    @Override
    public void setPrivate(Boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fill() throws IOException {
        block8: {
            if (this.filled.getAndSet(true)) break block8;
            String sha1 = this.getSha1();
            File torrentFile = this.getTorrentFile();
            String name = this.getName();
            String trackerURL = this.getTrackerURL();
            Boolean isPrivate = this.getPrivate();
            File torrentDataFile = this.getTorrentDataFile();
            File fastResumeFile = this.getFastResumeFile();
            if (torrentFile != null && torrentFile.exists()) {
                FileChannel fileChannel;
                FileInputStream fis;
                block7: {
                    fis = null;
                    fileChannel = null;
                    try {
                        fis = new FileInputStream(torrentFile);
                        fileChannel = fis.getChannel();
                        Map metaInfo = (Map)Token.parse(fileChannel);
                        BTDataImpl btData = new BTDataImpl(metaInfo);
                        if (name == null) {
                            name = btData.getName();
                            this.setName(name);
                        }
                        if (trackerURL == null) {
                            trackerURL = btData.getTrackerUris().get(0).toASCIIString();
                            this.setTrackerURL(trackerURL);
                        }
                        if (sha1 == null) {
                            sha1 = StringUtils.toHexString(btData.getInfoHash());
                            this.setSha1(sha1);
                        }
                        if (isPrivate != null) break block7;
                        isPrivate = btData.isPrivate();
                        this.setPrivate(isPrivate);
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(fileChannel);
                        IOUtils.close(fis);
                        throw throwable;
                    }
                }
                IOUtils.close(fileChannel);
                IOUtils.close(fis);
            }
            File downloadFolder = this.getDownloadFolder();
            if (name == null || downloadFolder == null || sha1 == null) {
                throw new IOException("There was an error initializing the torrent parameters.");
            }
            this.setFastResumeFile(fastResumeFile == null ? new File(downloadFolder, name + ".fastresume") : fastResumeFile);
            this.setTorrentDataFile(torrentDataFile == null ? new File(downloadFolder, name) : torrentDataFile);
            this.setTorrentFile(torrentFile == null ? new File(downloadFolder, name + ".torrent") : torrentFile);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("sha1: ").append(this.sha1).append("\n");
        sb.append("trackerURL: ").append(this.trackerURL).append("\n");
        sb.append("name: ").append(this.name).append("\n");
        sb.append("torrentFile: ").append(this.torrentFile).append("\n");
        sb.append("torrentDataFile: ").append(this.torrentDataFile).append("\n");
        sb.append("downloadFolder: ").append(this.downloadFolder).append("\n");
        sb.append("isPrivate: ").append(this.isPrivate).append("\n");
        sb.append("fastResumeFile: ").append(this.fastResumeFile).append("\n");
        return sb.toString();
    }
}

