/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.limewire.io.IpPort;

public class IpPortImpl
implements IpPort {
    private final InetSocketAddress addr;
    private final String addrString;

    public IpPortImpl(InetSocketAddress addr) {
        this(addr, addr.getAddress().getHostAddress());
    }

    public IpPortImpl(InetSocketAddress addr, String addrString) {
        this.addr = addr;
        this.addrString = addrString;
    }

    public IpPortImpl(InetAddress addr, int port) {
        this(new InetSocketAddress(addr, port));
    }

    public IpPortImpl(String host, int port) throws UnknownHostException {
        this(new InetSocketAddress(InetAddress.getByName(host), port), host);
    }

    public IpPortImpl(byte[] addr, int port) {
        this(new InetSocketAddress(IpPortImpl.getAddressFromBytes(addr), port), IpPortImpl.asString(addr));
    }

    public IpPortImpl(String hostport) throws UnknownHostException {
        int colonIdx = hostport.indexOf(":");
        if (colonIdx == hostport.length() - 1) {
            throw new UnknownHostException("invalid hostport: " + hostport);
        }
        String host = hostport;
        int port = 80;
        if (colonIdx != -1) {
            host = hostport.substring(0, colonIdx);
            try {
                port = Integer.parseInt(hostport.substring(colonIdx + 1).trim());
            }
            catch (NumberFormatException nfe) {
                throw new UnknownHostException("invalid hostport: " + hostport);
            }
        }
        this.addr = new InetSocketAddress(InetAddress.getByName(host), port);
        this.addrString = host;
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        return this.addr;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.addr.getAddress();
    }

    @Override
    public String getAddress() {
        return this.addrString;
    }

    @Override
    public int getPort() {
        return this.addr.getPort();
    }

    public String toString() {
        return "host: " + this.getAddress() + ", port: " + this.getPort();
    }

    private static String asString(byte[] addr) {
        StringBuilder sb = new StringBuilder(19);
        for (int i = 0; i < addr.length; ++i) {
            sb.append(addr[i] & 0xFF);
            if (i == addr.length - 1) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    private static InetAddress getAddressFromBytes(byte[] address) {
        try {
            return InetAddress.getByAddress(address);
        }
        catch (UnknownHostException uhe) {
            throw new IllegalArgumentException("invalid address: " + IpPortImpl.asString(address));
        }
    }
}

