/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.reactor;

import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.impl.nio.DefaultServerIOEventDispatch;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorStatus;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.limewire.http.reactor.DispatchedIOReactor;
import org.limewire.http.reactor.HttpChannel;
import org.limewire.http.reactor.HttpIOSession;
import org.limewire.io.IOUtils;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.nio.channel.ThrottleWriter;

public class DefaultDispatchedIOReactor
implements DispatchedIOReactor {
    public static final String IO_SESSION_KEY = "org.limewire.iosession";
    private static final Log LOG = LogFactory.getLog(DefaultDispatchedIOReactor.class);
    private final HttpParams params;
    protected volatile IOEventDispatch eventDispatch = null;
    private final Executor ioExecutor;

    public DefaultDispatchedIOReactor(HttpParams params, Executor ioExecutor) {
        if (params == null) {
            throw new IllegalArgumentException();
        }
        this.params = params;
        this.ioExecutor = ioExecutor;
    }

    @Override
    public void execute(IOEventDispatch eventDispatch) throws IOException {
        if (!(eventDispatch instanceof DefaultServerIOEventDispatch)) {
            throw new IllegalArgumentException("Event dispatch must be of type DefaultServerIOEventDispatch");
        }
        this.eventDispatch = eventDispatch;
    }

    protected void prepareSocket(Socket socket) throws IOException {
        socket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay(this.params));
        int linger = HttpConnectionParams.getLinger(this.params);
        if (linger >= 0) {
            socket.setSoLinger(linger > 0, linger);
        }
    }

    protected NHttpConnection connectSocket(AbstractNBSocket socket, Object attachment, String word) {
        HttpIOSession session = new HttpIOSession(socket, this.ioExecutor);
        session.setAttribute("http.session.attachment", attachment);
        session.setSocketTimeout(HttpConnectionParams.getSoTimeout(this.params));
        HttpChannel channel = new HttpChannel(session, this.eventDispatch, word);
        session.setHttpChannel(channel);
        ThrottleWriter throttleWriter = new ThrottleWriter(null);
        session.setThrottleChannel(throttleWriter);
        channel.setWriteChannel(throttleWriter);
        this.eventDispatch.connected(session);
        NHttpConnection conn = (NHttpConnection)session.getAttribute("http.connection");
        assert (conn != null);
        conn.getContext().setAttribute(IO_SESSION_KEY, session);
        socket.setReadObserver(channel);
        socket.setWriteObserver(channel);
        return conn;
    }

    @Override
    public NHttpConnection acceptConnection(String word, Socket socket) {
        try {
            this.prepareSocket(socket);
            return this.connectSocket((AbstractNBSocket)socket, null, word);
        }
        catch (IOException e) {
            LOG.info("Closing socket due to unexpected exception", e);
            IOUtils.close(socket);
            return null;
        }
    }

    @Override
    public IOReactorStatus getStatus() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdown() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdown(long gracePeriod) throws IOException {
        throw new UnsupportedOperationException();
    }
}

