/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.friend.impl.feature;

import com.google.inject.Inject;
import org.limewire.friend.api.Friend;
import org.limewire.friend.api.FriendConnection;
import org.limewire.friend.api.FriendConnectionEvent;
import org.limewire.friend.api.FriendPresence;
import org.limewire.friend.api.LibraryChanged;
import org.limewire.friend.api.LibraryChangedEvent;
import org.limewire.friend.api.feature.FeatureRegistry;
import org.limewire.friend.api.feature.FeatureTransport;
import org.limewire.friend.api.feature.LibraryChangedNotifier;
import org.limewire.friend.impl.feature.LibraryChangedNotifierFeatureInitializer;
import org.limewire.friend.impl.util.PresenceUtils;
import org.limewire.inject.EagerSingleton;
import org.limewire.listener.EventBean;
import org.limewire.listener.EventBroadcaster;

@EagerSingleton
class LibraryChangedDispatcher
implements FeatureTransport.Handler<LibraryChangedNotifier> {
    private final EventBean<FriendConnectionEvent> friendConnectionEvent;
    private final EventBroadcaster<LibraryChangedEvent> libChangedBroadcaster;

    @Inject
    public LibraryChangedDispatcher(EventBean<FriendConnectionEvent> friendConnectionEvent, EventBroadcaster<LibraryChangedEvent> libChangedBroadcaster, FeatureRegistry featureRegistry) {
        this.friendConnectionEvent = friendConnectionEvent;
        this.libChangedBroadcaster = libChangedBroadcaster;
        new LibraryChangedNotifierFeatureInitializer().register(featureRegistry);
    }

    @Override
    public void featureReceived(String from, LibraryChangedNotifier feature) {
        FriendPresence friendPresence;
        FriendConnection connection;
        Friend friend;
        FriendConnectionEvent event = this.friendConnectionEvent.getLastEvent();
        if (event != null && (friend = (connection = (FriendConnection)event.getSource()).getFriend(PresenceUtils.parseBareAddress(from))) != null && (friendPresence = friend.getPresences().get(from)) != null) {
            this.libChangedBroadcaster.broadcast(new LibraryChangedEvent(friendPresence, LibraryChanged.LIBRARY_CHANGED));
        }
    }
}

