/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.friend.impl;

import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.limewire.friend.api.FriendPresence;
import org.limewire.friend.api.feature.Feature;
import org.limewire.friend.api.feature.FeatureEvent;
import org.limewire.friend.api.feature.FeatureTransport;
import org.limewire.listener.EventBroadcaster;
import org.limewire.listener.EventListenerList;

public abstract class AbstractFriendPresence
implements FriendPresence {
    private final Map<URI, Feature> features = new ConcurrentHashMap<URI, Feature>(5, 0.75f, 1);
    private final Map<Class<? extends Feature<?>>, FeatureTransport> featureTransports = new ConcurrentHashMap(5, 0.75f, 1);
    private final EventBroadcaster<FeatureEvent> featureBroadcaster;

    public AbstractFriendPresence() {
        this(new EventListenerList<FeatureEvent>());
    }

    public AbstractFriendPresence(EventBroadcaster<FeatureEvent> featureEventBroadcaster) {
        this.featureBroadcaster = featureEventBroadcaster;
    }

    @Override
    public Collection<Feature> getFeatures() {
        return this.features.values();
    }

    @Override
    public Feature getFeature(URI id) {
        return this.features.get(id);
    }

    @Override
    public boolean hasFeatures(URI ... id) {
        for (URI uri : id) {
            if (this.getFeature(uri) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addFeature(Feature feature) {
        this.features.put(feature.getID(), feature);
        this.featureBroadcaster.broadcast(new FeatureEvent(this, FeatureEvent.Type.ADDED, feature));
    }

    @Override
    public void removeFeature(URI id) {
        Feature feature = this.features.remove(id);
        if (feature != null) {
            this.featureBroadcaster.broadcast(new FeatureEvent(this, FeatureEvent.Type.REMOVED, feature));
        }
    }

    public <T extends Feature<U>, U> FeatureTransport<U> getTransport(Class<T> feature) {
        return this.featureTransports.get(feature);
    }

    @Override
    public <D, F extends Feature<D>> void addTransport(Class<F> clazz, FeatureTransport<D> transport) {
        this.featureTransports.put(clazz, transport);
    }
}

