/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.search;

import com.google.common.collect.ImmutableList;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.util.AbstractList;
import java.util.List;
import java.util.Set;
import org.limewire.core.api.Category;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.core.api.URN;
import org.limewire.core.api.endpoint.RemoteHost;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.api.search.SearchResult;
import org.limewire.core.impl.friend.GnutellaPresence;
import org.limewire.core.impl.util.FilePropertyKeyPopulator;
import org.limewire.core.settings.SearchSettings;
import org.limewire.friend.api.FriendPresence;
import org.limewire.friend.api.feature.LimewireFeature;
import org.limewire.io.Connectable;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.IpPort;
import org.limewire.util.FileUtils;
import org.limewire.util.StringUtils;

public class RemoteFileDescAdapter
implements SearchResult {
    private static int ALTLOC_FACTOR = 1;
    private static int BROWSABLE_ANONYMOUS_PEER_FACTOR = 6;
    private static int NON_BROWSABLE_ANONYMOUS_PEER_FACTOR = 1;
    private static int FRIENDLY_PEER_FACTOR = 20;
    private final FriendPresence friendPresence;
    private final RemoteFileDesc rfd;
    private final String extension;
    private final List<IpPort> locs;
    private final Category category;
    private final int quality;
    private float relevance = -1.0f;

    @AssistedInject
    RemoteFileDescAdapter(@Assisted RemoteFileDesc rfd, @Assisted Set<? extends IpPort> locs, CategoryManager categoryManager) {
        this(rfd, locs, new GnutellaPresence.GnutellaPresenceWithGuid(rfd.getAddress(), rfd.getClientGUID()), categoryManager);
    }

    @AssistedInject
    RemoteFileDescAdapter(@Assisted RemoteFileDesc rfd, @Assisted Set<? extends IpPort> locs, @Assisted FriendPresence friendPresence, CategoryManager categoryManager) {
        this.rfd = rfd;
        this.locs = ImmutableList.copyOf(locs);
        this.friendPresence = friendPresence;
        this.extension = FileUtils.getFileExtension(rfd.getFileName());
        this.category = categoryManager.getCategoryForExtension(this.extension);
        this.quality = FilePropertyKeyPopulator.calculateQuality(this.category, this.extension, rfd.getSize(), rfd.getXMLDocument());
    }

    public RemoteFileDescAdapter(RemoteFileDescAdapter copy, FriendPresence presence) {
        this.rfd = copy.rfd;
        this.locs = copy.locs;
        this.friendPresence = presence;
        this.extension = copy.extension;
        this.category = copy.category;
        this.quality = copy.quality;
        this.relevance = copy.relevance;
    }

    @Override
    public float getRelevance(String query) {
        if (this.relevance != -1.0f) {
            return this.relevance;
        }
        this.relevance = 0.0f;
        if (!this.rfd.isBrowseHostEnabled()) {
            return 0.0f;
        }
        for (RemoteHost remoteHost : this.getSources()) {
            if (!(remoteHost instanceof RelevantRemoteHost)) continue;
            this.relevance += (float)((RelevantRemoteHost)remoteHost).getRelevance();
        }
        if (query != null && !query.isEmpty()) {
            this.relevance *= this.rfd.getRelevance(query);
        }
        return this.relevance;
    }

    public List<IpPort> getAlts() {
        return this.locs;
    }

    @Override
    public String getFileName() {
        return this.rfd.getFileName();
    }

    @Override
    public String getFileExtension() {
        return this.extension;
    }

    @Override
    public String getFileNameWithoutExtension() {
        return FileUtils.getFilenameNoExtension(this.rfd.getFileName());
    }

    @Override
    public boolean isLicensed() {
        LimeXMLDocument doc = this.rfd.getXMLDocument();
        return doc != null && doc.getLicenseString() != null;
    }

    @Override
    public Object getProperty(FilePropertyKey property) {
        switch (property) {
            case NAME: {
                return this.getFileNameWithoutExtension();
            }
            case DATE_CREATED: {
                return this.rfd.getCreationTime() == -1L ? null : Long.valueOf(this.rfd.getCreationTime());
            }
            case FILE_SIZE: {
                return this.rfd.getSize();
            }
            case QUALITY: {
                return this.quality == -1 ? null : Long.valueOf(this.quality);
            }
        }
        return FilePropertyKeyPopulator.get(this.category, property, this.rfd.getXMLDocument());
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    public RemoteFileDesc getRfd() {
        return this.rfd;
    }

    public FriendPresence getFriendPresence() {
        return this.friendPresence;
    }

    @Override
    public long getSize() {
        return this.rfd.getSize();
    }

    @Override
    public boolean isSpam() {
        return this.rfd.isSpam();
    }

    @Override
    public List<RemoteHost> getSources() {
        return new AbstractList<RemoteHost>(){

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public RemoteHost get(int index) {
                if (index == 0) {
                    return new RfdRemoteHost(RemoteFileDescAdapter.this.friendPresence, RemoteFileDescAdapter.this.rfd);
                }
                if (index - 1 < SearchSettings.ALT_LOCS_TO_DISPLAY.getValue()) {
                    return new AltLocRemoteHost((IpPort)RemoteFileDescAdapter.this.locs.get(index - 1));
                }
                throw new IndexOutOfBoundsException("index: " + index + ", size: " + this.size());
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public RemoteHost remove(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                return Math.min(SearchSettings.ALT_LOCS_TO_DISPLAY.getValue(), RemoteFileDescAdapter.this.locs.size()) + 1;
            }
        };
    }

    @Override
    public URN getUrn() {
        return this.rfd.getSHA1Urn();
    }

    @Override
    public String getMagnetURL() {
        MagnetOptions magnet = MagnetOptions.createMagnet(this.rfd, null, this.rfd.getClientGUID());
        return magnet.toExternalForm();
    }

    public String toString() {
        return StringUtils.toString(this, new Object[0]);
    }

    protected static interface RelevantRemoteHost
    extends RemoteHost {
        public int getRelevance();
    }

    static class AltLocRemoteHost
    implements RelevantRemoteHost {
        private final FriendPresence presence;

        AltLocRemoteHost(IpPort ipPort) {
            this.presence = ipPort instanceof Connectable ? new GnutellaPresence.GnutellaPresenceWithConnectable((Connectable)ipPort) : new GnutellaPresence.GnutellaPresenceWithConnectable(new ConnectableImpl(ipPort, false));
        }

        @Override
        public boolean isBrowseHostEnabled() {
            return true;
        }

        @Override
        public boolean isChatEnabled() {
            return false;
        }

        @Override
        public boolean isSharingEnabled() {
            return false;
        }

        @Override
        public FriendPresence getFriendPresence() {
            return this.presence;
        }

        @Override
        public int getRelevance() {
            return ALTLOC_FACTOR;
        }

        public String toString() {
            return "AltLoc Host For: " + this.presence;
        }
    }

    static class RfdRemoteHost
    implements RelevantRemoteHost {
        private final FriendPresence friendPresence;
        private final boolean browseHostEnabled;

        public RfdRemoteHost(FriendPresence presence, RemoteFileDesc rfd) {
            this.friendPresence = presence;
            this.browseHostEnabled = rfd.isBrowseHostEnabled();
        }

        @Override
        public boolean isBrowseHostEnabled() {
            if (this.friendPresence.getFriend().isAnonymous()) {
                return this.browseHostEnabled;
            }
            return this.friendPresence.hasFeatures(LimewireFeature.ID);
        }

        @Override
        public boolean isChatEnabled() {
            if (this.friendPresence.getFriend().isAnonymous()) {
                return false;
            }
            return this.friendPresence.hasFeatures(LimewireFeature.ID);
        }

        @Override
        public boolean isSharingEnabled() {
            if (this.friendPresence.getFriend().isAnonymous()) {
                return false;
            }
            return this.friendPresence.hasFeatures(LimewireFeature.ID);
        }

        @Override
        public FriendPresence getFriendPresence() {
            return this.friendPresence;
        }

        @Override
        public int getRelevance() {
            if (this.friendPresence.getFriend().isAnonymous()) {
                if (this.browseHostEnabled) {
                    return BROWSABLE_ANONYMOUS_PEER_FACTOR;
                }
                return NON_BROWSABLE_ANONYMOUS_PEER_FACTOR;
            }
            return FRIENDLY_PEER_FACTOR;
        }

        public String toString() {
            return "RFD Host for: " + this.friendPresence;
        }
    }

    public static interface Factory {
        public RemoteFileDescAdapter create(RemoteFileDesc var1, Set<? extends IpPort> var2);

        public RemoteFileDescAdapter create(RemoteFileDesc var1, Set<? extends IpPort> var2, FriendPresence var3);
    }
}

