/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.mojito;

import com.google.inject.Inject;
import com.limegroup.gnutella.dht.DHTEvent;
import com.limegroup.gnutella.dht.DHTEventListener;
import com.limegroup.gnutella.dht.DHTManager;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.limewire.core.api.mojito.MojitoManager;
import org.limewire.listener.SwingSafePropertyChangeSupport;
import org.limewire.mojito.MojitoDHT;

public class MojitoManagerImpl
implements MojitoManager {
    private final DHTManager manager;
    private final PropertyChangeSupport changeSupport = new SwingSafePropertyChangeSupport(this);

    @Inject
    public MojitoManagerImpl(DHTManager manager) {
        this.manager = manager;
    }

    @Inject
    public void registerListener() {
        this.manager.addEventListener(new DHTEventListener(){

            @Override
            public void handleDHTEvent(DHTEvent evt) {
                MojitoManagerImpl.this.changeSupport.firePropertyChange("started", false, evt.getType() != DHTEvent.Type.STOPPED);
            }
        });
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public String getName() {
        MojitoDHT dht = this.manager.getMojitoDHT();
        return dht != null ? dht.getName() : null;
    }

    @Override
    public boolean isRunning() {
        return this.manager.isRunning();
    }

    @Override
    public boolean handle(String command, PrintWriter out) {
        boolean result = false;
        try {
            MojitoDHT dht = this.manager.getMojitoDHT();
            if (dht == null) {
                out.println("Mojito is not running");
                return result;
            }
            Class<?> cmdHandler = Class.forName("org.limewire.mojito.CommandHandler");
            Method handle = cmdHandler.getMethod("handle", MojitoDHT.class, String.class, PrintWriter.class);
            result = (Boolean)handle.invoke(null, dht, command, out);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace(out);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace(out);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace(out);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace(out);
        }
        return result;
    }
}

