/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.download;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.matchers.Matcher;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Set;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadState;

class QueueTimeCalculator {
    private final EventList<DownloadItem> downloadingList;

    public QueueTimeCalculator(EventList<DownloadItem> downloadItems) {
        FilterList<DownloadItem> list = GlazedListsFactory.filterList(downloadItems, new DownloadStateMatcher(DownloadState.DOWNLOADING, new DownloadState[0]));
        Comparator<DownloadItem> dlComparator = new Comparator<DownloadItem>(){

            @Override
            public int compare(DownloadItem o1, DownloadItem o2) {
                return (int)(o1.getRemainingDownloadTime() - o2.getRemainingDownloadTime());
            }
        };
        this.downloadingList = GlazedListsFactory.sortedList(list, dlComparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRemainingQueueTime(DownloadItem queueItem) {
        this.downloadingList.getReadWriteLock().readLock().lock();
        try {
            if (queueItem.getState() != DownloadState.LOCAL_QUEUED) {
                long l = Long.MAX_VALUE;
                return l;
            }
            int priority = queueItem.getLocalQueuePriority();
            int index = priority - 1;
            if (index >= this.downloadingList.size() || index < 0) {
                long l = Long.MAX_VALUE;
                return l;
            }
            long l = ((DownloadItem)this.downloadingList.get(index)).getRemainingDownloadTime();
            return l;
        }
        finally {
            this.downloadingList.getReadWriteLock().readLock().unlock();
        }
    }

    private static class DownloadStateMatcher
    implements Matcher<DownloadItem> {
        private final Set<DownloadState> downloadStates;

        public DownloadStateMatcher(DownloadState first, DownloadState ... rest) {
            this.downloadStates = EnumSet.of(first, rest);
        }

        @Override
        public boolean matches(DownloadItem item) {
            if (item == null) {
                return false;
            }
            return this.downloadStates.contains((Object)item.getState());
        }
    }
}

