/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.api;

import java.util.Arrays;
import java.util.List;
import org.limewire.i18n.I18nMarker;

public enum Category {
    AUDIO(I18nMarker.marktr("Audio"), I18nMarker.marktr("Audio"), "audio"),
    VIDEO(I18nMarker.marktr("Video"), I18nMarker.marktr("Videos"), "video"),
    IMAGE(I18nMarker.marktr("Image"), I18nMarker.marktr("Images"), "image"),
    DOCUMENT(I18nMarker.marktr("Document"), I18nMarker.marktr("Documents"), "document"),
    PROGRAM(I18nMarker.marktr("Program"), I18nMarker.marktr("Programs"), "application"),
    OTHER(I18nMarker.marktr("Other"), I18nMarker.marktr("Other"), "other");

    private final String plural;
    private final String singular;
    private final String schemaName;

    private Category(String singular, String plural, String schemaName) {
        this.singular = singular;
        this.plural = plural;
        this.schemaName = schemaName;
    }

    public String getSingularName() {
        return this.singular;
    }

    public String getPluralName() {
        return this.plural;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String toString() {
        return this.plural;
    }

    public static List<Category> getCategoriesInOrder() {
        return Arrays.asList(AUDIO, VIDEO, IMAGE, DOCUMENT, PROGRAM, OTHER);
    }
}

