/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.limewire.concurrent.FutureEvent;
import org.limewire.concurrent.RunnableListeningFuture;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;

public class ListeningFutureTask<V>
extends FutureTask<V>
implements RunnableListeningFuture<V> {
    private final AtomicReference<EventListenerList<FutureEvent<V>>> listenersRef = new AtomicReference(new EventListenerList());
    private final EventListenerList.EventListenerListContext listenerContext = this.listenersRef.get().getContext();

    public ListeningFutureTask(Callable<V> callable) {
        super(callable);
    }

    public ListeningFutureTask(Runnable runnable, V result) {
        super(runnable, result);
    }

    @Override
    protected void done() {
        EventListenerList listeners = this.listenersRef.getAndSet(null);
        assert (listeners != null);
        if (listeners.size() > 0) {
            listeners.broadcast(FutureEvent.createEvent(this));
        }
    }

    @Override
    public void addFutureListener(EventListener<FutureEvent<V>> listener) {
        boolean added = false;
        EventListenerList<FutureEvent<V>> listeners = this.listenersRef.get();
        if (!this.isDone() && listeners != null) {
            listeners.addListener(new ProxyListener<V>(listener, this.listenerContext));
            added = this.listenersRef.compareAndSet(listeners, listeners);
        }
        if (!added) {
            EventListenerList.dispatch(listener, FutureEvent.createEvent(this), this.listenerContext);
        }
    }

    private static class ProxyListener<V>
    implements EventListener<FutureEvent<V>> {
        private final AtomicBoolean called = new AtomicBoolean(false);
        private final EventListenerList.EventListenerListContext listenerContext;
        private final EventListener<FutureEvent<V>> delegate;

        public ProxyListener(EventListener<FutureEvent<V>> delegate, EventListenerList.EventListenerListContext listenerContext) {
            this.delegate = delegate;
            this.listenerContext = listenerContext;
        }

        @Override
        public void handleEvent(FutureEvent<V> event) {
            if (!this.called.getAndSet(true)) {
                EventListenerList.dispatch(this.delegate, event, this.listenerContext);
            }
        }
    }
}

