/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.limewire.concurrent.FutureEvent;
import org.limewire.concurrent.ListeningFuture;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;

public abstract class ListeningFutureDelegator<S, R>
implements ListeningFuture<R> {
    private final ListeningFuture<S> delegate;
    private final EventListenerList.EventListenerListContext listenerContext;

    public ListeningFutureDelegator(ListeningFuture<S> delegate) {
        this.delegate = delegate;
        this.listenerContext = new EventListenerList.EventListenerListContext();
    }

    @Override
    public void addFutureListener(final EventListener<FutureEvent<R>> listener) {
        if (this.isDone()) {
            EventListenerList.dispatch(listener, FutureEvent.createEvent(this), this.listenerContext);
        } else {
            this.delegate.addFutureListener(new EventListener<FutureEvent<S>>(){

                @Override
                public void handleEvent(FutureEvent<S> event) {
                    EventListenerList.dispatch(listener, FutureEvent.createEvent(ListeningFutureDelegator.this), ListeningFutureDelegator.this.listenerContext);
                }
            });
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    @Override
    public R get() throws InterruptedException, ExecutionException {
        Object s;
        try {
            s = this.delegate.get();
        }
        catch (ExecutionException ee) {
            return this.convertException(ee);
        }
        return this.convertSource(s);
    }

    @Override
    public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Object s;
        try {
            s = this.delegate.get(timeout, unit);
        }
        catch (ExecutionException ee) {
            return this.convertException(ee);
        }
        return this.convertSource(s);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegate.isDone();
    }

    protected abstract R convertSource(S var1) throws ExecutionException;

    protected abstract R convertException(ExecutionException var1) throws ExecutionException;
}

