/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class FutureEvent<V> {
    private final Type type;
    private final V result;
    private final ExecutionException exception;

    private FutureEvent(Type type, V result, ExecutionException exception) {
        this.type = type;
        this.result = result;
        this.exception = exception;
    }

    public static <V> FutureEvent<V> createEvent(Future<V> future) {
        assert (future.isDone());
        boolean cancelled = future.isCancelled();
        V result = null;
        ExecutionException ee = null;
        if (!cancelled) {
            try {
                result = future.get();
            }
            catch (ExecutionException exception) {
                ee = exception;
            }
            catch (InterruptedException ie) {
                throw new IllegalStateException(ie);
            }
        }
        if (cancelled) {
            return FutureEvent.createCancelled();
        }
        if (ee != null) {
            return FutureEvent.createException(ee);
        }
        return FutureEvent.createSuccess(result);
    }

    public static <V> FutureEvent<V> createCancelled() {
        return new FutureEvent<Object>(Type.CANCELLED, null, null);
    }

    public static <V> FutureEvent<V> createSuccess(V result) {
        return new FutureEvent<V>(Type.SUCCESS, result, null);
    }

    public static <V> FutureEvent<V> createException(ExecutionException ee) {
        return new FutureEvent<Object>(Type.EXCEPTION, null, ee);
    }

    public Type getType() {
        return this.type;
    }

    public V getResult() {
        return this.result;
    }

    public ExecutionException getException() {
        return this.exception;
    }

    public static enum Type {
        SUCCESS,
        EXCEPTION,
        CANCELLED;

    }
}

