/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.limewire.collection.Buffer;
import org.limewire.collection.UnmodifiableIterator;

public class BucketQueue<E>
implements Cloneable,
Iterable<E> {
    private Buffer<E>[] buckets;
    private int size = 0;

    public BucketQueue(int priorities, int capacityPerPriority) throws IllegalArgumentException {
        if (priorities <= 0) {
            throw new IllegalArgumentException("Bad priorities: " + priorities);
        }
        if (capacityPerPriority <= 0) {
            throw new IllegalArgumentException("Bad capacity: " + capacityPerPriority);
        }
        this.buckets = new Buffer[priorities];
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new Buffer(capacityPerPriority);
        }
    }

    public BucketQueue(int[] capacities) throws IllegalArgumentException {
        if (capacities.length <= 0) {
            throw new IllegalArgumentException();
        }
        this.buckets = new Buffer[capacities.length];
        for (int i = 0; i < this.buckets.length; ++i) {
            if (capacities[i] <= 0) {
                throw new IllegalArgumentException("Non-positive capacity: " + capacities[i]);
            }
            this.buckets[i] = new Buffer(capacities[i]);
        }
    }

    public BucketQueue(BucketQueue<? extends E> other) {
        this.buckets = new Buffer[other.buckets.length];
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new Buffer<E>(other.buckets[i]);
        }
        this.size = other.size;
    }

    public void clear() {
        this.repOk();
        for (Buffer<E> bucket : this.buckets) {
            bucket.clear();
        }
        this.size = 0;
        this.repOk();
    }

    public E insert(E o, int priority) {
        this.repOk();
        if (priority < 0 || priority >= this.buckets.length) {
            throw new IllegalArgumentException("Bad priority: " + priority);
        }
        E ret = this.buckets[priority].addFirst(o);
        if (ret == null) {
            ++this.size;
        }
        this.repOk();
        return ret;
    }

    public boolean removeAll(Object o) {
        this.repOk();
        boolean ret = false;
        for (Buffer<E> bucket : this.buckets) {
            ret |= bucket.removeAll(o);
        }
        if (ret) {
            this.size = 0;
            for (Buffer<E> bucket : this.buckets) {
                this.size += bucket.getSize();
            }
        }
        this.repOk();
        return ret;
    }

    public E extractMax() throws NoSuchElementException {
        this.repOk();
        try {
            for (int i = this.buckets.length - 1; i >= 0; --i) {
                if (this.buckets[i].isEmpty()) continue;
                --this.size;
                E e = this.buckets[i].removeFirst();
                return e;
            }
            throw new NoSuchElementException();
        }
        finally {
            this.repOk();
        }
    }

    public E getMax() throws NoSuchElementException {
        for (int i = this.buckets.length - 1; i >= 0; --i) {
            if (this.buckets[i].isEmpty()) continue;
            return this.buckets[i].first();
        }
        throw new NoSuchElementException();
    }

    public int size() {
        return this.size;
    }

    public int size(int priority) throws IllegalArgumentException {
        if (priority < 0 || priority >= this.buckets.length) {
            throw new IllegalArgumentException("Bad priority: " + priority);
        }
        return this.buckets[priority].getSize();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new BucketQueueIterator(this.buckets.length - 1, this.size());
    }

    public Iterator<E> iterator(int startPriority, int n) throws IllegalArgumentException {
        if (startPriority < 0 || startPriority >= this.buckets.length) {
            throw new IllegalArgumentException("Bad priority: " + startPriority);
        }
        return new BucketQueueIterator(startPriority, n);
    }

    public BucketQueue<E> clone() throws CloneNotSupportedException {
        return new BucketQueue<E>(this);
    }

    private void repOk() {
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        for (int i = this.buckets.length - 1; i >= 0; --i) {
            if (i != this.buckets.length - 1) {
                buf.append(", ");
            }
            buf.append(this.buckets[i].toString());
        }
        buf.append("]");
        return buf.toString();
    }

    private class BucketQueueIterator
    extends UnmodifiableIterator<E> {
        private Iterator<E> currentIterator;
        private int currentBucket;
        private int left;

        public BucketQueueIterator(int startPriority, int n) {
            this.currentBucket = startPriority;
            this.currentIterator = BucketQueue.this.buckets[this.currentBucket].iterator();
            this.left = n;
        }

        @Override
        public synchronized boolean hasNext() {
            if (this.left <= 0) {
                return false;
            }
            if (this.currentIterator.hasNext()) {
                return true;
            }
            if (this.currentBucket < 0) {
                return false;
            }
            --this.currentBucket;
            while (this.currentBucket >= 0) {
                this.currentIterator = BucketQueue.this.buckets[this.currentBucket].iterator();
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                --this.currentBucket;
            }
            return false;
        }

        @Override
        public synchronized E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.left;
            return this.currentIterator.next();
        }
    }
}

