/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.activation.impl;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.limewire.activation.api.ActivationError;
import org.limewire.activation.api.ActivationEvent;
import org.limewire.activation.api.ActivationID;
import org.limewire.activation.api.ActivationItem;
import org.limewire.activation.api.ActivationManager;
import org.limewire.activation.api.ActivationModuleEvent;
import org.limewire.activation.api.ActivationSettingsController;
import org.limewire.activation.api.ActivationState;
import org.limewire.activation.api.ModuleCodeEvent;
import org.limewire.activation.impl.ActivationCommunicator;
import org.limewire.activation.impl.ActivationModel;
import org.limewire.activation.impl.ActivationResponse;
import org.limewire.activation.impl.ActivationResponseFactory;
import org.limewire.activation.impl.InvalidTokenException;
import org.limewire.activation.serial.ActivationSerializer;
import org.limewire.collection.Periodic;
import org.limewire.inject.EagerSingleton;
import org.limewire.io.InvalidDataException;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.OSUtils;
import org.limewire.util.StringUtils;

@EagerSingleton
class ActivationManagerImpl
implements ActivationManager,
Service {
    private static final Log LOG = LogFactory.getLog(ActivationManagerImpl.class);
    private static final String validChars = "23456789ABCDEFGHJKLMNPQRSTUVWXYZ";
    private static final String PATH_TO_BUY_PRO_LINK = "/Start Menu/Programs/LimeWire/Buy LimeWire PRO.lnk";
    private final EventListenerList<ActivationEvent> listeners = new EventListenerList();
    private final EventListenerList<ModuleCodeEvent> mcodeListeners = new EventListenerList();
    private final ActivationModel activationModel;
    private final ScheduledExecutorService scheduler;
    private final ActivationCommunicator activationCommunicator;
    private final ActivationSerializer activationSerializer;
    private final ActivationResponseFactory activationResponseFactory;
    private final ActivationSettingsController activationSettings;
    private Periodic activationContactor = null;
    private volatile ActivationError activationError = ActivationError.NO_ERROR;
    private volatile State lastState = State.NOT_ACTIVATED;
    private volatile State currentState = State.NOT_ACTIVATED;
    private volatile boolean attemptedToContactActivationServer = false;

    @Inject
    public ActivationManagerImpl(@Named(value="fastExecutor") ScheduledExecutorService scheduler, ActivationCommunicator activationCommunicator, ActivationModel activationModel, ActivationSerializer activationSerializer, ActivationResponseFactory activationReponseFactory, ActivationSettingsController activationSettings) {
        this.activationModel = activationModel;
        this.scheduler = scheduler;
        this.activationCommunicator = activationCommunicator;
        this.activationSerializer = activationSerializer;
        this.activationResponseFactory = activationReponseFactory;
        this.activationSettings = activationSettings;
    }

    @Override
    public void activateKey(String key) {
        if (!this.activateKeyInitAndValidate(key)) {
            return;
        }
        this.transitionToState(State.ACTIVATING);
        this.scheduleServerQueriesForKey(key, ActivationCommunicator.RequestType.USER_ACTIVATE, 0);
    }

    @Override
    public void refreshKey(String key) {
        if (!this.activateKeyInitAndValidate(key)) {
            return;
        }
        this.transitionToState(State.REFRESHING);
        this.scheduleServerQueriesForKey(key, ActivationCommunicator.RequestType.REFRESH, 0);
    }

    private void activateKeyAtStartup(String key) {
        if (!this.activateKeyInitAndValidate(key)) {
            return;
        }
        if (this.currentState != State.ACTIVATED_FROM_DISK) {
            this.transitionToState(State.REFRESHING);
        }
        this.scheduleServerQueriesForKey(key, ActivationCommunicator.RequestType.AUTO_STARTUP, 5);
    }

    private void scheduleServerQueriesForKey(String key, ActivationCommunicator.RequestType type, int numberOfRetries) {
        this.activationContactor = new Periodic(new ActivationTask(key, type, numberOfRetries), this.scheduler);
        this.activationContactor.rescheduleIfSooner(0L);
    }

    private boolean activateKeyInitAndValidate(String key) {
        if (this.activationContactor != null) {
            if (this.currentState == State.ACTIVATING || this.currentState == State.REFRESHING) {
                return false;
            }
            this.activationContactor.unschedule();
        }
        if (StringUtils.isEmpty(key)) {
            this.transitionToState(State.NOT_ACTIVATED, null);
            return false;
        }
        if (!this.isValidKey(key)) {
            this.transitionToState(State.NOT_ACTIVATED, this.activationResponseFactory.createErrorResponse(ActivationResponse.Type.NOTFOUND));
            return false;
        }
        return true;
    }

    @Override
    public ActivationState getActivationState() {
        return this.currentState.getActivationState();
    }

    private void setCurrentState(State newState) {
        this.lastState = this.currentState;
        this.currentState = newState;
    }

    @Override
    public boolean isMCodeUpToDate() {
        return this.activationSettings.getActivationKey().isEmpty() || this.attemptedToContactActivationServer;
    }

    @Override
    public ActivationError getActivationError() {
        return this.activationError;
    }

    @Override
    public List<ActivationItem> getActivationItems() {
        return this.activationModel.getActivationItems();
    }

    private void setActivationItems(List<ActivationItem> items) {
        this.activationModel.setActivationItems(items);
    }

    @Override
    public String getLicenseKey() {
        return this.activationSettings.getActivationKey();
    }

    @Override
    public String getModuleCode() {
        return this.activationSettings.getModuleCode();
    }

    private boolean isValidKey(String key) {
        if (key == null || key.length() != 12) {
            return false;
        }
        String givenChecksum = key.substring(key.length() - 1, key.length());
        String keyPart = key.substring(0, key.length() - 1);
        int sum = 0;
        for (int counter = 0; counter < keyPart.length(); ++counter) {
            char currentChar = keyPart.charAt(counter);
            int positionInValidChars = validChars.indexOf(currentChar);
            if (positionInValidChars == -1) {
                return false;
            }
            sum += (counter + 1) * positionInValidChars;
        }
        int modulusOfSum = sum % validChars.length();
        char correctChecksum = validChars.charAt(modulusOfSum);
        return givenChecksum.equals(String.valueOf(correctChecksum));
    }

    @Override
    public boolean isActive(ActivationID id) {
        return this.activationModel.isActive(id);
    }

    @Override
    public boolean isProActive() {
        return this.activationModel.isActive(ActivationID.TURBO_CHARGED_DOWNLOADS_MODULE) || this.activationModel.isActive(ActivationID.OPTIMIZED_SEARCH_RESULT_MODULE) || this.activationModel.isActive(ActivationID.TECH_SUPPORT_MODULE);
    }

    @Override
    public String getServiceName() {
        return "Activation-Manager Service";
    }

    @Inject
    public void register(ServiceRegistry registry) {
        registry.register(this);
    }

    @Override
    public void initialize() {
        this.loadFromDisk();
    }

    private void loadFromDisk() {
        this.scheduler.execute(new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        String jsonString = ActivationManagerImpl.this.activationSerializer.readFromDisk();
                        if (jsonString != null && jsonString.length() > 0) {
                            ActivationResponse response = ActivationManagerImpl.this.activationResponseFactory.createFromDiskJson(jsonString);
                            ActivationManagerImpl.this.transitionToState(State.ACTIVATED_FROM_DISK, response);
                        }
                    }
                    catch (IOException e) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error("Error reading serialized json string.", e);
                        }
                    }
                    catch (InvalidDataException e) {
                        if (!LOG.isErrorEnabled()) break block5;
                        LOG.error("Error parsing json string.", e);
                    }
                }
            }
        });
    }

    private void writeToDisk(final String moduleInfoAsJson) {
        this.scheduler.execute(new Runnable(){

            @Override
            public void run() {
                block4: {
                    try {
                        ActivationManagerImpl.this.activationSerializer.writeToDisk(moduleInfoAsJson);
                    }
                    catch (IOException e) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error("Error saving json string to disk", e);
                        }
                    }
                    catch (GeneralSecurityException e) {
                        if (!LOG.isErrorEnabled()) break block4;
                        LOG.error("Error saving json string to disk", e);
                    }
                }
            }
        });
    }

    @Override
    public void start() {
        String storedLicenseKey = this.getLicenseKey();
        if (!storedLicenseKey.isEmpty()) {
            this.activateKeyAtStartup(storedLicenseKey);
        } else {
            this.mcodeListeners.broadcast(new ModuleCodeEvent(""));
        }
    }

    @Override
    public void stop() {
        if (this.activationContactor != null) {
            this.activationContactor.unschedule();
        }
    }

    @Override
    public void addModuleListener(EventListener<ActivationModuleEvent> listener) {
        this.activationModel.addListener(listener);
    }

    @Override
    public boolean removeModuleListener(EventListener<ActivationModuleEvent> listener) {
        return this.activationModel.removeListener(listener);
    }

    @Override
    public void addListener(EventListener<ActivationEvent> listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public boolean removeListener(EventListener<ActivationEvent> listener) {
        return this.listeners.removeListener(listener);
    }

    @Override
    public void addMCodeListener(EventListener<ModuleCodeEvent> listener) {
        this.mcodeListeners.addListener(listener);
    }

    @Override
    public boolean removeMCodeListener(EventListener<ModuleCodeEvent> listener) {
        return this.mcodeListeners.removeListener(listener);
    }

    private void transitionToState(State newState) {
        assert (newState != State.ACTIVATED_FROM_DISK && newState != State.ACTIVATED_FROM_SERVER && newState != State.NOT_ACTIVATED);
        this.transitionToState(newState, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transitionToState(State newState, ActivationResponse response) {
        LOG.debugf("transitioning to state {0}", (Object)newState);
        ActivationManagerImpl activationManagerImpl = this;
        synchronized (activationManagerImpl) {
            switch (newState) {
                case NOT_ACTIVATED: {
                    this.notActivated(response);
                    break;
                }
                case ACTIVATING: {
                    this.activating();
                    break;
                }
                case REFRESHING: {
                    this.refreshing();
                    break;
                }
                case ACTIVATED_FROM_DISK: {
                    if (this.currentState == State.ACTIVATED_FROM_SERVER) {
                        return;
                    }
                    this.activatedFromDisk(response);
                    break;
                }
                case ACTIVATED_FROM_SERVER: {
                    this.activated(response);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown state " + (Object)((Object)newState));
                }
            }
        }
        this.listeners.broadcast(new ActivationEvent(this.getActivationState(), this.getActivationError()));
    }

    private void notActivated(ActivationResponse response) {
        ActivationError error;
        boolean removeMcode = false;
        boolean removeKey = false;
        if (response == null) {
            error = ActivationError.NO_ERROR;
            removeMcode = true;
            removeKey = true;
        } else {
            switch (response.getResponseType()) {
                case ERROR: {
                    if (this.currentState == State.REFRESHING) {
                        this.activationError = ActivationError.COMMUNICATION_ERROR;
                        this.setCurrentState(this.lastState);
                        return;
                    }
                    error = ActivationError.COMMUNICATION_ERROR;
                    break;
                }
                case REMOVE: {
                    error = ActivationError.INVALID_KEY;
                    removeMcode = true;
                    removeKey = true;
                    break;
                }
                case STOP: {
                    error = ActivationError.INVALID_KEY;
                    removeKey = true;
                    break;
                }
                case NOTFOUND: {
                    error = ActivationError.INVALID_KEY;
                    removeMcode = true;
                    removeKey = true;
                    break;
                }
                case BLOCKED: {
                    this.activationSettings.setActivationKey(response.getLid());
                    this.activationSettings.setModuleCode(response.getMCode());
                    error = ActivationError.BLOCKED_KEY;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown state " + (Object)((Object)response.getResponseType()));
                }
            }
            LOG.debugf("Error responseType:{0} error:{1}", (Object)response.getResponseType(), (Object)error);
        }
        if (this.currentState.getActivationState() != ActivationState.AUTHORIZED || error != ActivationError.COMMUNICATION_ERROR) {
            if (error == ActivationError.NO_ERROR || error == ActivationError.INVALID_KEY || error == ActivationError.BLOCKED_KEY) {
                this.removeData(removeMcode, removeKey);
            }
            this.activationError = error;
            this.setCurrentState(State.NOT_ACTIVATED);
            this.activationSettings.setLastStartPro(false);
        }
    }

    private void removeData(boolean removeMCode, boolean removeKey) {
        if (removeKey) {
            this.activationSettings.setActivationKey("");
        }
        this.writeToDisk("");
        this.setActivationItems(Collections.<ActivationItem>emptyList());
        if (removeMCode) {
            this.activationSettings.setModuleCode("");
        }
    }

    private void refreshing() {
        this.activationError = ActivationError.NO_ERROR;
        this.setCurrentState(State.REFRESHING);
    }

    private void activating() {
        this.activationError = ActivationError.NO_ERROR;
        this.setCurrentState(State.ACTIVATING);
    }

    private void activatedFromDisk(ActivationResponse response) {
        this.setActivationItems(response.getActivationItems());
        this.activationSettings.setLastStartPro(this.isProActive());
        this.activationSettings.setActivationKey(response.getLid());
        this.activationSettings.setModuleCode(response.getMCode());
        this.activationError = ActivationError.NO_ERROR;
        this.setCurrentState(State.ACTIVATED_FROM_DISK);
    }

    private void activated(ActivationResponse response) {
        this.writeToDisk(response.getJSONString());
        this.activationSettings.setActivationKey(response.getLid());
        this.activationSettings.setModuleCode(response.getMCode());
        this.setActivationItems(response.getActivationItems());
        this.deleteBuyProLinks(this.activationSettings.isLastStartPro());
        this.activationSettings.setLastStartPro(this.isProActive());
        this.activationError = ActivationError.NO_ERROR;
        this.setCurrentState(State.ACTIVATED_FROM_SERVER);
    }

    private void deleteBuyProLinks(boolean lastStartPro) {
        if (OSUtils.isWindows() && (!lastStartPro || this.activationSettings.isNewInstall())) {
            File pathToLimeWireAllUsersStartMenuLink;
            File pathToLimeWireStartMenuLink = new File(System.getProperty("user.home") + PATH_TO_BUY_PRO_LINK);
            if (pathToLimeWireStartMenuLink.exists()) {
                pathToLimeWireStartMenuLink.delete();
            }
            if ((pathToLimeWireAllUsersStartMenuLink = new File(System.getProperty("user.home") + "/../All Users" + PATH_TO_BUY_PRO_LINK)).exists()) {
                pathToLimeWireAllUsersStartMenuLink.delete();
            }
        }
    }

    private class ActivationTask
    implements Runnable {
        private int consecutiveFailedRetries = 0;
        private final int maxFailedConsecutiveRetries;
        private final String key;
        private ActivationCommunicator.RequestType type;

        ActivationTask(String key, ActivationCommunicator.RequestType type, int maxFailedConsecutiveRetriesParam) {
            this.maxFailedConsecutiveRetries = maxFailedConsecutiveRetriesParam;
            this.key = key;
            this.type = type;
        }

        @Override
        public void run() {
            long refreshValInMs;
            ActivationResponse response;
            try {
                response = ActivationManagerImpl.this.activationCommunicator.activate(this.key, this.type);
                this.consecutiveFailedRetries = 0;
            }
            catch (IOException e) {
                response = ActivationManagerImpl.this.activationResponseFactory.createErrorResponse(ActivationResponse.Type.ERROR);
                this.retryOnErrorIfNecessary();
            }
            catch (InvalidDataException e) {
                response = ActivationManagerImpl.this.activationResponseFactory.createErrorResponse(ActivationResponse.Type.ERROR);
            }
            catch (InvalidTokenException e) {
                response = ActivationManagerImpl.this.activationResponseFactory.createErrorResponse(ActivationResponse.Type.NOTFOUND);
            }
            State state = this.getNextState(response.getResponseType());
            ActivationManagerImpl.this.attemptedToContactActivationServer = true;
            if (this.type != ActivationCommunicator.RequestType.PING) {
                ActivationManagerImpl.this.transitionToState(state, response);
                ActivationManagerImpl.this.mcodeListeners.broadcast(new ModuleCodeEvent(ActivationManagerImpl.this.getModuleCode()));
            }
            if (state == State.ACTIVATED_FROM_SERVER && (refreshValInMs = (long)(response.getRefreshIntervalInMinutes() * 60 * 1000)) > 0L) {
                this.type = ActivationCommunicator.RequestType.PING;
                ActivationManagerImpl.this.activationContactor.rescheduleIfSooner(refreshValInMs);
            }
        }

        private State getNextState(ActivationResponse.Type type) {
            return type == ActivationResponse.Type.VALID ? State.ACTIVATED_FROM_SERVER : State.NOT_ACTIVATED;
        }

        private void retryOnErrorIfNecessary() {
            if (++this.consecutiveFailedRetries <= this.maxFailedConsecutiveRetries) {
                int nextDelayInMs = this.consecutiveFailedRetries * 5000;
                ActivationManagerImpl.this.activationContactor.rescheduleIfSooner(nextDelayInMs);
            }
        }
    }

    private static enum State {
        NOT_ACTIVATED(ActivationState.NOT_AUTHORIZED),
        ACTIVATING(ActivationState.AUTHORIZING),
        REFRESHING(ActivationState.REFRESHING),
        ACTIVATED_FROM_SERVER(ActivationState.AUTHORIZED),
        ACTIVATED_FROM_DISK(ActivationState.AUTHORIZED);

        private ActivationState state;

        private State(ActivationState state) {
            this.state = state;
        }

        public ActivationState getActivationState() {
            return this.state;
        }
    }
}

