/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import org.jaudiotagger.tag.id3.Id3FieldType;

public enum ID3v22FieldKey {
    ARTIST("TP1", Id3FieldType.TEXT),
    ALBUM("TAL", Id3FieldType.TEXT),
    TITLE("TT2", Id3FieldType.TEXT),
    TRACK("TRK", Id3FieldType.TEXT),
    YEAR("TYE", Id3FieldType.TEXT),
    GENRE("TCO", Id3FieldType.TEXT),
    COMMENT("COM", Id3FieldType.TEXT),
    ALBUM_ARTIST("TP2", Id3FieldType.TEXT),
    COMPOSER("TCM", Id3FieldType.TEXT),
    GROUPING("TT1", Id3FieldType.TEXT),
    DISC_NO("TPA", Id3FieldType.TEXT),
    BPM("TBP", Id3FieldType.TEXT),
    ENCODER("TEN", Id3FieldType.TEXT),
    MUSICBRAINZ_ARTISTID("TXX", "MusicBrainz Artist Id", Id3FieldType.TEXT),
    MUSICBRAINZ_RELEASEID("TXX", "MusicBrainz Album Id", Id3FieldType.TEXT),
    MUSICBRAINZ_RELEASEARTISTID("TXX", "MusicBrainz Album Artist Id", Id3FieldType.TEXT),
    MUSICBRAINZ_TRACK_ID("UFI", "http://musicbrainz.org", Id3FieldType.TEXT),
    MUSICBRAINZ_DISC_ID("TXX", "MusicBrainz Disc Id", Id3FieldType.TEXT),
    MUSICIP_ID("TXX", "MusicIP PUID", Id3FieldType.TEXT),
    AMAZON_ID("TXX", "ASIN", Id3FieldType.TEXT),
    MUSICBRAINZ_RELEASE_STATUS("TXX", "MusicBrainz Album Status", Id3FieldType.TEXT),
    MUSICBRAINZ_RELEASE_TYPE("TXX", "MusicBrainz Album Type", Id3FieldType.TEXT),
    MUSICBRAINZ_RELEASE_COUNTRY("TXX", "MusicBrainz Album Release Country", Id3FieldType.TEXT),
    LYRICS("ULT", Id3FieldType.TEXT),
    IS_COMPILATION("TCP", Id3FieldType.TEXT),
    ARTIST_SORT("TSP", Id3FieldType.TEXT),
    ALBUM_ARTIST_SORT("TS2", Id3FieldType.TEXT),
    ALBUM_SORT("TSA", Id3FieldType.TEXT),
    TITLE_SORT("TST", Id3FieldType.TEXT),
    COMPOSER_SORT("TSC", Id3FieldType.TEXT),
    COVER_ART("PIC", Id3FieldType.BINARY),
    ISRC("TRC", Id3FieldType.TEXT),
    BARCODE("TXX", "BARCODE", Id3FieldType.TEXT),
    CATALO_NO("TXX", "CATALOGNUMBER", Id3FieldType.TEXT),
    RECORD_LABEL("TPB", Id3FieldType.TEXT),
    LYRICIST("TXT", Id3FieldType.TEXT),
    CONDUCTOR("TPE", Id3FieldType.TEXT),
    REMIXER("TP4", Id3FieldType.TEXT),
    MEDIA("TMT", Id3FieldType.TEXT),
    URL_OFFICIAL_RELEASE_SITE("WXX", "OFFICIAL_RELEASE", Id3FieldType.TEXT),
    URL_DISCOGS_RELEASE_SITE("WXX", "DISCOGS_RELEASE", Id3FieldType.TEXT),
    URL_WIKIPEDIA_RELEASE_SITE("WXX", "WIKIPEDIA_RELEASE", Id3FieldType.TEXT),
    URL_OFFICIAL_ARTIST_SITE("WAR", Id3FieldType.TEXT),
    URL_DISCOGS_ARTIST_SITE("WXX", "DISCOGS_ARTIST", Id3FieldType.TEXT),
    URL_WIKIPEDIA_ARTIST_SITE("WXX", "WIKIPEDIA_ARTIST", Id3FieldType.TEXT),
    LANGUAGE("TLA", Id3FieldType.TEXT),
    KEY("TKE", Id3FieldType.TEXT);

    private String fieldName;
    private String frameId;
    private String subId;
    private Id3FieldType fieldType;

    private ID3v22FieldKey(String frameId, Id3FieldType fieldType) {
        this.frameId = frameId;
        this.fieldType = fieldType;
        this.fieldName = frameId;
    }

    private ID3v22FieldKey(String frameId, String subId, Id3FieldType fieldType) {
        this.frameId = frameId;
        this.subId = subId;
        this.fieldType = fieldType;
        this.fieldName = frameId + ":" + subId;
    }

    public Id3FieldType getFieldType() {
        return this.fieldType;
    }

    public String getFrameId() {
        return this.frameId;
    }

    public String getSubId() {
        return this.subId;
    }

    public String getFieldName() {
        return this.fieldName;
    }
}

