/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;

public class ByteArraySizeTerminated
extends AbstractDataType {
    public ByteArraySizeTerminated(String identifier, AbstractTagFrameBody frameBody) {
        super(identifier, frameBody);
    }

    public ByteArraySizeTerminated(ByteArraySizeTerminated object) {
        super(object);
    }

    @Override
    public int getSize() {
        int len = 0;
        if (this.value != null) {
            len = ((byte[])this.value).length;
        }
        return len;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ByteArraySizeTerminated)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public void readByteArray(byte[] arr, int offset) throws InvalidDataTypeException {
        if (arr == null) {
            throw new NullPointerException("Byte array is null");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Offset to byte array is out of bounds: offset = " + offset + ", array.length = " + arr.length);
        }
        if (offset >= arr.length) {
            this.value = null;
            return;
        }
        int len = arr.length - offset;
        this.value = new byte[len];
        System.arraycopy(arr, offset, this.value, 0, len);
    }

    public String toString() {
        return this.getSize() + " bytes";
    }

    @Override
    public byte[] writeByteArray() {
        return (byte[])this.value;
    }
}

