/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.tag;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.data.ContentDescriptor;
import org.jaudiotagger.audio.asf.tag.AsfFieldKey;
import org.jaudiotagger.audio.asf.tag.AsfTagCoverField;
import org.jaudiotagger.audio.asf.tag.AsfTagField;
import org.jaudiotagger.audio.asf.tag.AsfTagTextField;
import org.jaudiotagger.audio.generic.AbstractTag;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagFieldKey;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.datatype.Artwork;
import org.jaudiotagger.tag.reference.PictureTypes;

public final class AsfTag
extends AbstractTag {
    public static final Set<AsfFieldKey> COMMON_FIELDS;
    public static final Set<AsfFieldKey> DESCRIPTION_FIELDS;
    static EnumMap<TagFieldKey, AsfFieldKey> tagFieldToAsfField;
    private final boolean copyFields;

    public static boolean storesDescriptor(ContentDescriptor contentDesc) {
        AsfFieldKey asfFieldKey = AsfFieldKey.getAsfFieldKey(contentDesc.getName());
        return DESCRIPTION_FIELDS.contains((Object)asfFieldKey);
    }

    public AsfTag() {
        this(false);
    }

    public AsfTag(boolean copyFields) {
        this.copyFields = copyFields;
    }

    public AsfTag(Tag source, boolean copyFields) throws UnsupportedEncodingException {
        this(copyFields);
        this.copyFrom(source);
    }

    public void addCopyright(String copyRight) {
        this.add(this.createCopyrightField(copyRight));
    }

    public void addRating(String rating) {
        this.add(this.createRatingField(rating));
    }

    private void copyFrom(Tag source) throws UnsupportedEncodingException {
        if (source == null) {
            throw new NullPointerException();
        }
        Iterator<TagField> fieldIterator = source.getFields();
        while (fieldIterator.hasNext()) {
            TagField copy = this.copyFrom(fieldIterator.next());
            if (copy == null) continue;
            super.add(copy);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TagField copyFrom(TagField source) {
        TagField result = null;
        if (!this.isCopyingFields()) return source;
        String internalId = source.getId();
        if (source instanceof TagTextField) {
            String content = ((TagTextField)source).getContent();
            return new AsfTagTextField(internalId, content);
        }
        if (source instanceof AsfTagField) {
            return new AsfTagCoverField(((AsfTagCoverField)source).getDescriptor());
        }
        if (!(source instanceof AsfTagField)) throw new RuntimeException("Unknown Asf Tag Field class:" + source.getClass());
        return new AsfTagField(((AsfTagField)source).getDescriptor());
    }

    @Override
    public TagField createAlbumField(String content) {
        return new AsfTagTextField(this.getAlbumId(), content);
    }

    @Override
    public TagField createArtistField(String content) {
        return new AsfTagTextField(this.getArtistId(), content);
    }

    @Override
    public TagField createCommentField(String content) {
        return new AsfTagTextField(this.getCommentId(), content);
    }

    public TagField createCopyrightField(String content) {
        return new AsfTagTextField(AsfFieldKey.COPYRIGHT.getFieldName(), content);
    }

    @Override
    public TagField createGenreField(String content) {
        return new AsfTagTextField(this.getGenreId(), content);
    }

    public TagField createRatingField(String content) {
        return new AsfTagTextField(AsfFieldKey.RATING.getFieldName(), content);
    }

    @Override
    public TagField createTagField(TagFieldKey genericKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        if (value == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        return this.createTagField(tagFieldToAsfField.get((Object)genericKey), value);
    }

    public TagField createTagField(AsfFieldKey asfFieldKey, String value) throws KeyNotFoundException {
        if (value == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        if (asfFieldKey == null) {
            throw new KeyNotFoundException("key not found for value:" + value);
        }
        switch (asfFieldKey) {
            case COVER_ART: {
                throw new UnsupportedOperationException("Cover Art cannot be created using this method");
            }
        }
        System.out.println("Creating with value:" + value);
        return new AsfTagTextField(asfFieldKey.getFieldName(), value);
    }

    @Override
    public TagField createTitleField(String content) {
        return new AsfTagTextField(this.getTitleId(), content);
    }

    @Override
    public TagField createTrackField(String content) throws FieldDataInvalidException {
        return new AsfTagTextField(this.getTrackId(), content);
    }

    @Override
    public TagField createYearField(String content) {
        return new AsfTagTextField(this.getYearId(), content);
    }

    public TagField createArtworkField(byte[] data) throws FieldDataInvalidException {
        return new AsfTagCoverField(data, PictureTypes.DEFAULT_ID, null);
    }

    @Override
    public TagField createArtworkField(Artwork artwork) throws FieldDataInvalidException {
        return new AsfTagCoverField(artwork.getBinaryData(), artwork.getPictureType(), artwork.getDescription());
    }

    public void deleteTagField(AsfFieldKey fieldKey) {
        super.deleteField(fieldKey.getFieldName());
    }

    @Override
    public void deleteTagField(TagFieldKey tagFieldKey) throws KeyNotFoundException {
        if (tagFieldKey == null) {
            throw new KeyNotFoundException();
        }
        super.deleteField(tagFieldToAsfField.get((Object)tagFieldKey).getFieldName());
    }

    @Override
    public List<TagField> get(TagFieldKey tagFieldKey) throws KeyNotFoundException {
        if (tagFieldKey == null) {
            throw new KeyNotFoundException();
        }
        return super.get(tagFieldToAsfField.get((Object)tagFieldKey).getFieldName());
    }

    @Override
    protected String getAlbumId() {
        return AsfFieldKey.ALBUM.getFieldName();
    }

    @Override
    protected String getArtistId() {
        return AsfFieldKey.AUTHOR.getFieldName();
    }

    public <F extends AsfTagField> Iterator<F> getAsfFields() {
        if (!this.isCopyingFields()) {
            throw new IllegalStateException("Since the field conversion is not enabled, this method cannot be executed");
        }
        final Iterator<TagField> it = this.getFields();
        return new Iterator<F>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public F next() {
                return (AsfTagField)it.next();
            }

            @Override
            public void remove() {
                it.remove();
            }
        };
    }

    @Override
    protected String getCommentId() {
        return AsfFieldKey.DESCRIPTION.getFieldName();
    }

    public List<TagField> getCopyright() {
        return this.get(AsfFieldKey.COPYRIGHT.getFieldName());
    }

    @Override
    public String getFirst(TagFieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        return super.getFirst(tagFieldToAsfField.get((Object)genericKey).getFieldName());
    }

    @Override
    public AsfTagField getFirstField(TagFieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        return (AsfTagField)super.getFirstField(tagFieldToAsfField.get((Object)genericKey).getFieldName());
    }

    public String getFirstCopyright() {
        return this.getFirst(AsfFieldKey.COPYRIGHT.getFieldName());
    }

    public String getFirstRating() {
        return this.getFirst(AsfFieldKey.RATING.getFieldName());
    }

    @Override
    protected String getGenreId() {
        return AsfFieldKey.GENRE.getFieldName();
    }

    public List<TagField> getRating() {
        return this.get(AsfFieldKey.RATING.getFieldName());
    }

    @Override
    protected String getTitleId() {
        return AsfFieldKey.TITLE.getFieldName();
    }

    @Override
    protected String getTrackId() {
        return AsfFieldKey.TRACK.getFieldName();
    }

    @Override
    protected String getYearId() {
        return AsfFieldKey.YEAR.getFieldName();
    }

    @Override
    protected boolean isAllowedEncoding(String enc) {
        return AsfHeader.ASF_CHARSET.name().equals(enc);
    }

    public boolean isCopyingFields() {
        return this.copyFields;
    }

    private boolean isValidField(TagField field) {
        if (field == null) {
            return false;
        }
        if (!(field instanceof AsfTagField)) {
            return false;
        }
        return !field.isEmpty();
    }

    @Override
    public void add(TagField field) {
        if (this.isValidField(field)) {
            if (AsfFieldKey.isMultiValued((field = this.copyFrom(field)).getId())) {
                super.add(field);
            } else {
                super.set(field);
            }
        }
    }

    @Override
    public void set(TagField field) {
        if (this.isValidField(field)) {
            field = this.copyFrom(field);
            super.set(field);
        }
    }

    public void setCopyright(String Copyright) {
        this.set(this.createCopyrightField(Copyright));
    }

    public void setRating(String rating) {
        this.set(this.createRatingField(rating));
    }

    @Override
    public List<Artwork> getArtworkList() {
        List<TagField> coverartList = this.get(TagFieldKey.COVER_ART);
        ArrayList<Artwork> artworkList = new ArrayList<Artwork>(coverartList.size());
        for (TagField next : coverartList) {
            AsfTagCoverField coverArt = (AsfTagCoverField)next;
            Artwork artwork = new Artwork();
            artwork.setBinaryData(coverArt.getRawImageData());
            artwork.setMimeType(coverArt.getMimeType());
            artwork.setDescription(coverArt.getDescription());
            artwork.setPictureType(coverArt.getPictureType());
            artworkList.add(artwork);
        }
        return artworkList;
    }

    static {
        tagFieldToAsfField = new EnumMap(TagFieldKey.class);
        tagFieldToAsfField.put(TagFieldKey.ARTIST, AsfFieldKey.AUTHOR);
        tagFieldToAsfField.put(TagFieldKey.ALBUM, AsfFieldKey.ALBUM);
        tagFieldToAsfField.put(TagFieldKey.TITLE, AsfFieldKey.TITLE);
        tagFieldToAsfField.put(TagFieldKey.TRACK, AsfFieldKey.TRACK);
        tagFieldToAsfField.put(TagFieldKey.YEAR, AsfFieldKey.YEAR);
        tagFieldToAsfField.put(TagFieldKey.GENRE, AsfFieldKey.GENRE);
        tagFieldToAsfField.put(TagFieldKey.COMMENT, AsfFieldKey.DESCRIPTION);
        tagFieldToAsfField.put(TagFieldKey.ALBUM_ARTIST, AsfFieldKey.ALBUM_ARTIST);
        tagFieldToAsfField.put(TagFieldKey.COMPOSER, AsfFieldKey.COMPOSER);
        tagFieldToAsfField.put(TagFieldKey.GROUPING, AsfFieldKey.GROUPING);
        tagFieldToAsfField.put(TagFieldKey.DISC_NO, AsfFieldKey.DISC_NO);
        tagFieldToAsfField.put(TagFieldKey.BPM, AsfFieldKey.BPM);
        tagFieldToAsfField.put(TagFieldKey.ENCODER, AsfFieldKey.ENCODER);
        tagFieldToAsfField.put(TagFieldKey.MUSICBRAINZ_ARTISTID, AsfFieldKey.MUSICBRAINZ_ARTISTID);
        tagFieldToAsfField.put(TagFieldKey.MUSICBRAINZ_RELEASEID, AsfFieldKey.MUSICBRAINZ_RELEASEID);
        tagFieldToAsfField.put(TagFieldKey.MUSICBRAINZ_RELEASEARTISTID, AsfFieldKey.MUSICBRAINZ_RELEASEARTISTID);
        tagFieldToAsfField.put(TagFieldKey.MUSICBRAINZ_TRACK_ID, AsfFieldKey.MUSICBRAINZ_TRACK_ID);
        tagFieldToAsfField.put(TagFieldKey.MUSICBRAINZ_DISC_ID, AsfFieldKey.MUSICBRAINZ_DISC_ID);
        tagFieldToAsfField.put(TagFieldKey.MUSICIP_ID, AsfFieldKey.MUSICIP_ID);
        tagFieldToAsfField.put(TagFieldKey.AMAZON_ID, AsfFieldKey.AMAZON_ID);
        tagFieldToAsfField.put(TagFieldKey.MUSICBRAINZ_RELEASE_STATUS, AsfFieldKey.MUSICBRAINZ_RELEASE_STATUS);
        tagFieldToAsfField.put(TagFieldKey.MUSICBRAINZ_RELEASE_TYPE, AsfFieldKey.MUSICBRAINZ_RELEASE_TYPE);
        tagFieldToAsfField.put(TagFieldKey.MUSICBRAINZ_RELEASE_COUNTRY, AsfFieldKey.MUSICBRAINZ_RELEASE_COUNTRY);
        tagFieldToAsfField.put(TagFieldKey.LYRICS, AsfFieldKey.LYRICS);
        tagFieldToAsfField.put(TagFieldKey.IS_COMPILATION, AsfFieldKey.IS_COMPILATION);
        tagFieldToAsfField.put(TagFieldKey.ARTIST_SORT, AsfFieldKey.ARTIST_SORT);
        tagFieldToAsfField.put(TagFieldKey.ALBUM_ARTIST_SORT, AsfFieldKey.ALBUM_ARTIST_SORT);
        tagFieldToAsfField.put(TagFieldKey.ALBUM_SORT, AsfFieldKey.ALBUM_SORT);
        tagFieldToAsfField.put(TagFieldKey.TITLE_SORT, AsfFieldKey.TITLE_SORT);
        tagFieldToAsfField.put(TagFieldKey.COMPOSER_SORT, AsfFieldKey.COMPOSER_SORT);
        tagFieldToAsfField.put(TagFieldKey.COVER_ART, AsfFieldKey.COVER_ART);
        tagFieldToAsfField.put(TagFieldKey.ISRC, AsfFieldKey.ISRC);
        tagFieldToAsfField.put(TagFieldKey.CATALOG_NO, AsfFieldKey.CATALOG_NO);
        tagFieldToAsfField.put(TagFieldKey.BARCODE, AsfFieldKey.BARCODE);
        tagFieldToAsfField.put(TagFieldKey.RECORD_LABEL, AsfFieldKey.RECORD_LABEL);
        tagFieldToAsfField.put(TagFieldKey.LYRICIST, AsfFieldKey.LYRICIST);
        tagFieldToAsfField.put(TagFieldKey.CONDUCTOR, AsfFieldKey.CONDUCTOR);
        tagFieldToAsfField.put(TagFieldKey.REMIXER, AsfFieldKey.REMIXER);
        tagFieldToAsfField.put(TagFieldKey.MOOD, AsfFieldKey.MOOD);
        tagFieldToAsfField.put(TagFieldKey.MEDIA, AsfFieldKey.MEDIA);
        tagFieldToAsfField.put(TagFieldKey.URL_OFFICIAL_RELEASE_SITE, AsfFieldKey.URL_OFFICIAL_RELEASE_SITE);
        tagFieldToAsfField.put(TagFieldKey.URL_DISCOGS_RELEASE_SITE, AsfFieldKey.URL_DISCOGS_RELEASE_SITE);
        tagFieldToAsfField.put(TagFieldKey.URL_WIKIPEDIA_RELEASE_SITE, AsfFieldKey.URL_WIKIPEDIA_RELEASE_SITE);
        tagFieldToAsfField.put(TagFieldKey.URL_OFFICIAL_ARTIST_SITE, AsfFieldKey.URL_OFFICIAL_ARTIST_SITE);
        tagFieldToAsfField.put(TagFieldKey.URL_DISCOGS_ARTIST_SITE, AsfFieldKey.URL_DISCOGS_ARTIST_SITE);
        tagFieldToAsfField.put(TagFieldKey.URL_WIKIPEDIA_ARTIST_SITE, AsfFieldKey.URL_WIKIPEDIA_ARTIST_SITE);
        tagFieldToAsfField.put(TagFieldKey.LANGUAGE, AsfFieldKey.LANGUAGE);
        tagFieldToAsfField.put(TagFieldKey.KEY, AsfFieldKey.INITIAL_KEY);
        COMMON_FIELDS = new HashSet<AsfFieldKey>();
        COMMON_FIELDS.add(AsfFieldKey.ALBUM);
        COMMON_FIELDS.add(AsfFieldKey.AUTHOR);
        COMMON_FIELDS.add(AsfFieldKey.DESCRIPTION);
        COMMON_FIELDS.add(AsfFieldKey.GENRE);
        COMMON_FIELDS.add(AsfFieldKey.TITLE);
        COMMON_FIELDS.add(AsfFieldKey.TRACK);
        COMMON_FIELDS.add(AsfFieldKey.YEAR);
        DESCRIPTION_FIELDS = new HashSet<AsfFieldKey>();
        DESCRIPTION_FIELDS.add(AsfFieldKey.AUTHOR);
        DESCRIPTION_FIELDS.add(AsfFieldKey.COPYRIGHT);
        DESCRIPTION_FIELDS.add(AsfFieldKey.DESCRIPTION);
        DESCRIPTION_FIELDS.add(AsfFieldKey.RATING);
        DESCRIPTION_FIELDS.add(AsfFieldKey.TITLE);
    }
}

