/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.data.StreamBitratePropertiesChunk;
import org.jaudiotagger.audio.asf.io.ChunkReader;
import org.jaudiotagger.audio.asf.util.Utils;

public class StreamBitratePropertiesReader
implements ChunkReader {
    protected StreamBitratePropertiesReader() {
    }

    @Override
    public boolean canFail() {
        return false;
    }

    @Override
    public GUID getApplyingId() {
        return GUID.GUID_STREAM_BITRATE_PROPERTIES;
    }

    @Override
    public Chunk read(GUID guid, InputStream stream, long chunkStart) throws IOException {
        StreamBitratePropertiesChunk result = null;
        BigInteger chunkLen = Utils.readBig64(stream);
        result = new StreamBitratePropertiesChunk(chunkLen);
        long recordCount = Utils.readUINT16(stream);
        int i = 0;
        while ((long)i < recordCount) {
            int flags = Utils.readUINT16(stream);
            long avgBitrate = Utils.readUINT32(stream);
            result.addBitrateRecord(flags & 0xFF, avgBitrate);
            ++i;
        }
        result.setPosition(chunkStart);
        return result;
    }
}

