/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FullRequestInputStream
extends FilterInputStream {
    public FullRequestInputStream(InputStream source) {
        super(source);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int totalRead = 0;
        int read = -1;
        while (totalRead < len) {
            read = super.read(b, off + totalRead, len - totalRead);
            if (read >= 0) {
                totalRead += read;
            }
            if (read != -1) continue;
            throw new IOException(len - totalRead + " more bytes expected.");
        }
        return totalRead;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped;
        long currSkipped;
        int zeroSkipCnt = 0;
        for (skipped = 0L; skipped < n; skipped += currSkipped) {
            currSkipped = super.skip(n - skipped);
            if (currSkipped != 0L || ++zeroSkipCnt != 2) continue;
            return skipped;
        }
        return skipped;
    }
}

