/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.ContentDescription;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.ChunkReader;
import org.jaudiotagger.audio.asf.util.Utils;

public class ContentDescriptionReader
implements ChunkReader {
    public static String readFixedSizeUTF16Str(InputStream stream, int strLen) throws IOException {
        byte[] strBytes = new byte[strLen];
        int read = stream.read(strBytes);
        if (read == strBytes.length) {
            if (strBytes.length >= 2 && strBytes[strBytes.length - 1] == 0 && strBytes[strBytes.length - 2] == 0) {
                byte[] copy = new byte[strBytes.length - 2];
                System.arraycopy(strBytes, 0, copy, 0, strBytes.length - 2);
                strBytes = copy;
            }
            return new String(strBytes, "UTF-16LE");
        }
        throw new IllegalStateException("Couldn't read the necessary amount of bytes.");
    }

    protected ContentDescriptionReader() {
    }

    @Override
    public boolean canFail() {
        return false;
    }

    @Override
    public GUID getApplyingId() {
        return GUID.GUID_CONTENTDESCRIPTION;
    }

    private int[] getStringSizes(InputStream stream) throws IOException {
        int[] result = new int[5];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Utils.readUINT16(stream);
        }
        return result;
    }

    @Override
    public Chunk read(GUID guid, InputStream stream, long chunkStart) throws IOException {
        BigInteger chunkSize = Utils.readBig64(stream);
        int[] stringSizes = this.getStringSizes(stream);
        String[] strings = new String[stringSizes.length];
        for (int i = 0; i < strings.length; ++i) {
            if (stringSizes[i] <= 0) continue;
            strings[i] = ContentDescriptionReader.readFixedSizeUTF16Str(stream, stringSizes[i]);
        }
        ContentDescription result = new ContentDescription(chunkStart, chunkSize);
        if (stringSizes[0] > 0) {
            result.setTitle(strings[0]);
        }
        if (stringSizes[1] > 0) {
            result.setAuthor(strings[1]);
        }
        if (stringSizes[2] > 0) {
            result.setCopyRight(strings[2]);
        }
        if (stringSizes[3] > 0) {
            result.setComment(strings[3]);
        }
        if (stringSizes[4] > 0) {
            result.setRating(strings[4]);
        }
        return result;
    }
}

