/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.exception;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.bushe.swing.exception.AWTExceptionHandler;
import org.jdesktop.jdic.desktop.Desktop;
import org.jdesktop.jdic.desktop.Message;

public class ExceptionDialog
extends JDialog {
    public static final int PREFERRED_WIDTH = 600;
    private Throwable throwable;
    private Component detailsComponent;
    private JSeparator separator;
    private String emailAddress;

    public ExceptionDialog(Frame frame, Throwable throwable, boolean bl) {
        this(frame, throwable, bl, null);
    }

    public ExceptionDialog(Frame frame, Throwable throwable, boolean bl, String string) {
        super(frame, "Application Error", bl);
        this.throwable = throwable;
        this.emailAddress = string;
        this.setupClose();
        this.initUI(throwable);
    }

    protected void initUI(Throwable throwable) {
        this.detailsComponent = this.createDetailsComponent(throwable);
        JLabel jLabel = this.createErrorIconLabel();
        JLabel jLabel2 = this.createErrorMessageComponent();
        JComponent jComponent = this.createButtonPanelComponent();
        JLabel jLabel3 = this.createTitleComponent();
        this.separator = this.createSeparator();
        this.doLayout(jLabel, jLabel3, jLabel2, jComponent, this.detailsComponent, this.separator);
    }

    protected void doLayout(JLabel jLabel, JLabel jLabel2, JLabel jLabel3, Component component, Component component2, Component component3) {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel.add((Component)jPanel2, "Center");
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.setContentPane(jPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(0, 10, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 11;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = insets;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 20, 5, 5);
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel2.add(component, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        jPanel2.add(component3, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel2.add(component2, gridBagConstraints);
    }

    protected JSeparator createSeparator() {
        JSeparator jSeparator = new JSeparator();
        jSeparator.setPreferredSize(new Dimension(600, 3));
        if (this.getDefaultDetailsVisible()) {
            jSeparator.setVisible(false);
        }
        return jSeparator;
    }

    protected void setupClose() {
        this.setDefaultCloseOperation(2);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExceptionDialog.this.setVisible(false);
            }
        };
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
    }

    protected Component createDetailsComponent(Throwable throwable) {
        JTextArea jTextArea = new JTextArea(this.getDetailComponentMessageText(), 25, 80);
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        if (!this.getDefaultDetailsVisible()) {
            jScrollPane.setVisible(false);
        }
        jScrollPane.setPreferredSize(new Dimension(600, jScrollPane.getPreferredSize().height));
        return jScrollPane;
    }

    protected String getDetailComponentMessageText() {
        return this.determineDetailMessage(this.throwable);
    }

    protected String getEmailMessageText() {
        return this.determineDetailMessage(this.throwable);
    }

    protected JComponent createButtonPanelComponent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        AbstractAction abstractAction = new AbstractAction("OK"){

            public void actionPerformed(ActionEvent actionEvent) {
                ExceptionDialog.this.close();
            }
        };
        JButton jButton = new JButton(abstractAction);
        jPanel2.add(jButton);
        JButton jButton2 = new JButton("Copy");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExceptionDialog.this.copy();
            }
        });
        jPanel2.add(jButton2);
        if (AWTExceptionHandler.getErrorEmailAddress() != null) {
            JButton jButton3 = new JButton("Email");
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ExceptionDialog.this.email();
                }
            });
            jPanel2.add(jButton3);
        }
        if (this.detailsComponent != null) {
            boolean bl = this.getDefaultDetailsVisible();
            final JButton jButton4 = new JButton(bl ? "Details >>" : "<< Details");
            jButton4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if ("<< Details".equals(jButton4.getText())) {
                        ExceptionDialog.this.detailsComponent.setVisible(true);
                        ExceptionDialog.this.separator.setVisible(false);
                        jButton4.setText("Details >>");
                    } else {
                        ExceptionDialog.this.detailsComponent.setVisible(false);
                        ExceptionDialog.this.separator.setVisible(true);
                        jButton4.setText("<< Details");
                    }
                    ExceptionDialog.this.pack();
                }
            });
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)jPanel2, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            JPanel jPanel3 = new JPanel(new FlowLayout(2));
            jPanel3.add(jButton4);
            jPanel.add((Component)jPanel3, gridBagConstraints);
            jPanel.setBackground(Color.BLACK);
        }
        this.getRootPane().setDefaultButton(jButton);
        return jPanel;
    }

    protected boolean getDefaultDetailsVisible() {
        return false;
    }

    protected JLabel createErrorIconLabel() {
        return new JLabel(this.getErrorIcon());
    }

    protected JLabel createTitleComponent() {
        return new JLabel("The following error occurred:");
    }

    protected JLabel createErrorMessageComponent() {
        return new JLabel(this.getMessageText(this.throwable));
    }

    protected Icon getErrorIcon() {
        return UIManager.getIcon("OptionPane.errorIcon");
    }

    protected void copy() {
        StringSelection stringSelection = new StringSelection(this.getDetailComponentMessageText());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
    }

    protected void email() {
        if (this.emailAddress != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        Message message = new Message();
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(ExceptionDialog.this.emailAddress);
                        message.setToAddrs(arrayList);
                        message.setSubject(ExceptionDialog.this.getErrorEmailSubject());
                        message.setBody(ExceptionDialog.this.getEmailMessageText());
                        Desktop.mail(message);
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException("Could not email previous error.  Likely a Java Desktop Integration configuraiton issue.  " + throwable, throwable);
                    }
                }
            });
        }
    }

    protected String determineDetailMessage(Throwable throwable) {
        String string = "" + new Date() + "\n";
        Throwable throwable2 = this.getRootCause(throwable);
        if (throwable2 == throwable) {
            string = string + throwable.getMessage() + "\n";
            string = string + AWTExceptionHandler.stackTraceToString(throwable);
        } else {
            string = string + "Root Cause:" + throwable2.getMessage() + "\n";
            string = string + AWTExceptionHandler.stackTraceToString(throwable2);
            string = string + "Full Trace:" + throwable.getMessage() + "\n";
            string = string + AWTExceptionHandler.stackTraceToString(throwable);
        }
        String string2 = "\nJVM properties:";
        Properties properties = System.getProperties();
        for (Object object : properties.keySet()) {
            string2 = string2 + "\n" + object + "=" + properties.get(object);
        }
        return string + string2;
    }

    protected String getMessageText(Throwable throwable) {
        if (throwable == null) {
            return "No throwable available.";
        }
        throwable = this.getRootCause(throwable);
        String string = "<html>";
        String string2 = throwable.getMessage();
        if (string2 == null) {
            string = string + "No message available";
        } else if (string2.length() < 80) {
            string = string + string2;
        } else {
            String string3 = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \throwable\n\r\f", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string3.length() + string4.length() > 80) {
                    string = string + string3 + "<br>";
                    string3 = "";
                    continue;
                }
                string3 = string3 + string4;
            }
            string = string + string3;
        }
        return string + "</html>";
    }

    protected String getErrorEmailSubject() {
        return "Application Error";
    }

    protected void close() {
        this.dispose();
    }

    private Throwable getRootCause(Throwable throwable) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    public void setEmailAddress(String string) {
        this.emailAddress = string;
    }
}

