/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.exception;

import java.awt.Frame;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JDialog;
import org.bushe.swing.exception.ExceptionDialog;

public class AWTExceptionHandler {
    private static String emailAddress;
    private static AWTErrorLogger logger;

    public static String getErrorEmailAddress() {
        return emailAddress;
    }

    public static void setErrorEmailAddress(String string) {
        emailAddress = string;
    }

    public static void setLogger(AWTErrorLogger aWTErrorLogger) {
        logger = aWTErrorLogger;
    }

    public void handle(Throwable throwable) {
        Frame frame = this.getFrameForMessageDialog();
        if (frame == null) {
            this.handleThrowableWithoutFrame(throwable);
        } else {
            this.handleThrowableWithFrame(frame, throwable);
        }
    }

    protected void handleThrowableWithoutFrame(Throwable throwable) {
        this.logError(throwable);
    }

    protected void handleThrowableWithFrame(Frame frame, Throwable throwable) {
        this.logError(throwable);
        JDialog jDialog = this.createErrorDialog(frame, throwable);
        jDialog.pack();
        jDialog.setVisible(true);
    }

    protected void logError(Throwable throwable) {
        if (logger == null) {
            System.err.println(throwable);
            throwable.printStackTrace(System.err);
        } else {
            logger.log(throwable);
        }
    }

    protected JDialog createErrorDialog(Frame frame, Throwable throwable) {
        return new ExceptionDialog(frame, throwable, false);
    }

    protected Frame getFrameForMessageDialog() {
        Frame frame = null;
        Frame[] frameArray = Frame.getFrames();
        if (frameArray != null && frameArray.length > 0) {
            frame = frameArray[0];
        }
        return frame;
    }

    public static String stackTraceToString(Throwable throwable) {
        if (throwable == null) {
            return "No stack trace available.";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.getBuffer().toString();
    }

    public static interface AWTErrorLogger {
        public void log(Throwable var1);
    }
}

