/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.event;

import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.bushe.swing.event.ContainerEventServiceFinder;
import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventSubscriber;
import org.bushe.swing.event.EventTopicSubscriber;

public class ContainerEventServiceRegistrar {
    private JComponent jComp;
    private EventSubscriber eventSubscriber;
    private Class[] eventClasses;
    private EventTopicSubscriber eventTopicSubscriber;
    private String[] topics;
    private EventService containerEventService;

    public ContainerEventServiceRegistrar(JComponent jComponent) {
        this(jComponent, null, null, null, null);
    }

    public ContainerEventServiceRegistrar(JComponent jComponent, EventSubscriber eventSubscriber, Class clazz) {
        this(jComponent, eventSubscriber, new Class[]{clazz}, null, null);
    }

    public ContainerEventServiceRegistrar(JComponent jComponent, EventTopicSubscriber eventTopicSubscriber, String string) {
        this(jComponent, null, null, eventTopicSubscriber, new String[]{string});
    }

    public ContainerEventServiceRegistrar(JComponent jComponent, EventSubscriber eventSubscriber, Class[] classArray) {
        this(jComponent, eventSubscriber, classArray, null, null);
    }

    public ContainerEventServiceRegistrar(JComponent jComponent, EventTopicSubscriber eventTopicSubscriber, String[] stringArray) {
        this(jComponent, null, null, eventTopicSubscriber, stringArray);
    }

    public ContainerEventServiceRegistrar(JComponent jComponent, EventSubscriber eventSubscriber, Class[] classArray, EventTopicSubscriber eventTopicSubscriber, String[] stringArray) {
        this.jComp = jComponent;
        this.eventSubscriber = eventSubscriber;
        this.eventClasses = classArray;
        this.eventTopicSubscriber = eventTopicSubscriber;
        this.topics = stringArray;
        if (jComponent == null) {
            throw new NullPointerException("JComponent is null");
        }
        this.updateContainerEventService();
        jComponent.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                ContainerEventServiceRegistrar.this.updateContainerEventService();
            }
        });
        jComponent.addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent containerEvent) {
                ContainerEventServiceRegistrar.this.updateContainerEventService();
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                ContainerEventServiceRegistrar.this.updateContainerEventService();
            }
        });
        jComponent.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                ContainerEventServiceRegistrar.this.updateContainerEventService();
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
                ContainerEventServiceRegistrar.this.updateContainerEventService();
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                ContainerEventServiceRegistrar.this.updateContainerEventService();
            }
        });
    }

    protected void updateContainerEventService() {
        Object object;
        int n;
        if (this.containerEventService != null) {
            if (this.eventClasses != null) {
                for (n = 0; n < this.eventClasses.length; ++n) {
                    object = this.eventClasses[n];
                    this.containerEventService.unsubscribe((Class)object, this.eventSubscriber);
                }
            }
            if (this.topics != null) {
                for (n = 0; n < this.topics.length; ++n) {
                    object = this.topics[n];
                    this.containerEventService.unsubscribe((String)object, this.eventTopicSubscriber);
                }
            }
        }
        this.containerEventService = ContainerEventServiceFinder.getEventService(this.jComp);
        if (this.containerEventService != null) {
            if (this.eventClasses != null) {
                for (n = 0; n < this.eventClasses.length; ++n) {
                    object = this.eventClasses[n];
                    this.containerEventService.subscribe((Class)object, this.eventSubscriber);
                }
            }
            if (this.topics != null) {
                for (n = 0; n < this.topics.length; ++n) {
                    object = this.topics[n];
                    this.containerEventService.subscribe((String)object, this.eventTopicSubscriber);
                }
            }
        }
    }

    public EventService getContainerEventService() {
        if (this.containerEventService != null) {
            return this.containerEventService;
        }
        this.updateContainerEventService();
        return this.containerEventService;
    }
}

