/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.utility;

import com.lti.utils.StringUtils;
import java.util.ArrayList;
import javax.media.Buffer;
import javax.media.Format;

public final class LoggingStringUtils {
    private LoggingStringUtils() {
    }

    public static String bufferToStr(Buffer buffer) {
        if (buffer == null) {
            return "null";
        }
        StringBuffer b = new StringBuffer();
        b.append(buffer);
        b.append(" seq=" + buffer.getSequenceNumber());
        b.append(" off=" + buffer.getOffset());
        b.append(" len=" + buffer.getLength());
        b.append(" flags=[" + LoggingStringUtils.bufferFlagsToStr(buffer.getFlags()) + "]");
        b.append(" fmt=[" + buffer.getFormat() + "]");
        if (buffer.getData() != null && buffer.getData() instanceof byte[]) {
            b.append(" data=[" + buffer.getData() + " " + StringUtils.byteArrayToHexString((byte[])buffer.getData(), buffer.getLength(), buffer.getOffset()) + "]");
        } else if (buffer.getData() != null) {
            b.append(" data=[" + buffer.getData() + "]");
        } else {
            b.append(" data=[null]");
        }
        return b.toString();
    }

    public static String bufferFlagsToStr(int flags) {
        ArrayList<String> strings = new ArrayList<String>();
        if ((flags & 1) != 0) {
            strings.add("FLAG_EOM");
        }
        if ((flags & 2) != 0) {
            strings.add("FLAG_DISCARD");
        }
        if ((flags & 4) != 0) {
            strings.add("FLAG_SILENCE");
        }
        if ((flags & 8) != 0) {
            strings.add("FLAG_SID");
        }
        if ((flags & 0x10) != 0) {
            strings.add("FLAG_KEY_FRAME");
        }
        if ((flags & 0x40) != 0) {
            strings.add("FLAG_NO_WAIT");
        }
        if ((flags & 0x60) != 0) {
            strings.add("FLAG_NO_SYNC");
        }
        if ((flags & 0x80) != 0) {
            strings.add("FLAG_SYSTEM_TIME");
        }
        if ((flags & 0x100) != 0) {
            strings.add("FLAG_RELATIVE_TIME");
        }
        if ((flags & 0x200) != 0) {
            strings.add("FLAG_FLUSH");
        }
        if ((flags & 0x400) != 0) {
            strings.add("FLAG_SYSTEM_MARKER");
        }
        if ((flags & 0x800) != 0) {
            strings.add("FLAG_RTP_MARKER");
        }
        if ((flags & 0x1000) != 0) {
            strings.add("FLAG_RTP_TIME");
        }
        if ((flags & 0x2000) != 0) {
            strings.add("FLAG_BUF_OVERFLOWN");
        }
        if ((flags & 0x4000) != 0) {
            strings.add("FLAG_BUF_UNDERFLOWN");
        }
        if ((flags & 0x8000) != 0) {
            strings.add("FLAG_LIVE_DATA");
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < strings.size(); ++i) {
            if (b.length() != 0) {
                b.append(" | ");
            }
            b.append(strings.get(i));
        }
        return b.toString();
    }

    public static String plugInResultToStr(int result) {
        switch (result) {
            case 0: {
                return "BUFFER_PROCESSED_OK";
            }
            case 1: {
                return "BUFFER_PROCESSED_FAILED";
            }
            case 2: {
                return "INPUT_BUFFER_NOT_CONSUMED";
            }
            case 4: {
                return "OUTPUT_BUFFER_NOT_FILLED";
            }
            case 8: {
                return "PLUGIN_TERMINATED";
            }
        }
        return "" + result;
    }

    public static String formatToStr(Format f) {
        return "" + f;
    }
}

