/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.application;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.media.protocol.ContentDescriptor;
import net.sf.fmj.ui.wizards.ProcessorWizardConfig;
import net.sf.fmj.ui.wizards.RTPTransmitWizardConfig;
import net.sf.fmj.ui.wizards.TrackConfig;
import net.sf.fmj.ui.wizards.TranscodeWizardConfig;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.SerializationUtils;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class PlayerPanelPrefs {
    private static final Logger logger = LoggerSingleton.logger;
    private static final String version = "0.1";
    public List recentUrls = new ArrayList();
    public boolean autoPlay = true;
    public boolean autoLoop = false;
    public RTPTransmitWizardConfig rtpTransmitWizardConfig = new RTPTransmitWizardConfig();
    public TranscodeWizardConfig transcodeWizardConfig = new TranscodeWizardConfig();
    private static final String ELEMENT_REGISTRY = "fmj-studio-prefs";
    private static final String ATTR_VERSION = "version";
    private static final String ELEMENT_RECENT_URLS = "recent-urls";
    private static final String ELEMENT_RECENT_URL = "url";
    private static final String ELEMENT_RTP_TRANSMIT_WIZARD_CONFIG = "rtp-transmit-wizard-config";
    private static final String ELEMENT_TRANSCODE_WIZARD_CONFIG = "transcode-wizard-config";

    public static File getFile() {
        String filename = ".fmjstudio.prefs.xml";
        String home = System.getProperty("user.home");
        return new File(home + File.separator + ".fmjstudio.prefs.xml");
    }

    public void load(Reader reader) throws IOException {
        try {
            SAXBuilder saxBuilder = new SAXBuilder();
            Document document = saxBuilder.build(reader);
            this.loadDocument(document);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void write(Writer writer) throws IOException {
        Document document = this.buildDocument();
        XMLOutputter xmlOutputter = new XMLOutputter();
        xmlOutputter.setFormat(Format.getPrettyFormat());
        xmlOutputter.output(document, writer);
    }

    private void loadDocument(Document document) throws IOException {
        Element rootElement = document.getRootElement();
        String versionString = rootElement.getAttributeValue(ATTR_VERSION);
        logger.info("FMJStudio preferences document version " + versionString);
        Element element_RecentUrls = rootElement.getChild(ELEMENT_RECENT_URLS);
        this.parseElement_RecentUrls(element_RecentUrls);
        Element e = rootElement.getChild("auto-play");
        if (e != null) {
            this.autoPlay = e.getTextTrim().equals("true");
        }
        if ((e = rootElement.getChild("auto-loop")) != null) {
            this.autoLoop = e.getTextTrim().equals("true");
        }
        this.parseElement_RTPTransmitWizardConfig(rootElement.getChild(ELEMENT_RTP_TRANSMIT_WIZARD_CONFIG));
        this.parseElement_TranscodeWizardConfig(rootElement.getChild(ELEMENT_TRANSCODE_WIZARD_CONFIG));
    }

    private Document buildDocument() throws IOException {
        Document document = new Document();
        Element rootElement = new Element(ELEMENT_REGISTRY);
        rootElement.setAttribute(ATTR_VERSION, version);
        document.setRootElement(rootElement);
        rootElement.addContent((Content)this.buildElement_RecentUrls());
        Element e = new Element("auto-play");
        e.setText("" + this.autoPlay);
        rootElement.addContent((Content)e);
        e = new Element("auto-loop");
        e.setText("" + this.autoLoop);
        rootElement.addContent((Content)e);
        rootElement.addContent((Content)this.buildElement_RTPTransmitWizardConfig());
        rootElement.addContent((Content)this.buildElement_TranscodeWizardConfig());
        return document;
    }

    private void parseElement_RecentUrls(Element element) {
        this.recentUrls.clear();
        List list = element.getChildren(ELEMENT_RECENT_URL);
        for (int i = 0; i < list.size(); ++i) {
            Element stringElement = (Element)list.get(i);
            this.recentUrls.add(stringElement.getTextTrim());
        }
    }

    private Element buildElement_RecentUrls() {
        Element element = new Element(ELEMENT_RECENT_URLS);
        for (String s : this.recentUrls) {
            Element element_RecentUrl = new Element(ELEMENT_RECENT_URL);
            element_RecentUrl.setText(s);
            element.addContent((Content)element_RecentUrl);
        }
        return element;
    }

    private static void parseElement_ProcessorWizardConfig(Element element, ProcessorWizardConfig processorWizardConfig) {
        Element e = element.getChild("source-url");
        if (e != null) {
            processorWizardConfig.url = e.getTextTrim();
        }
        if ((e = element.getChild("content-descriptor-encoding")) != null) {
            processorWizardConfig.contentDescriptor = new ContentDescriptor(e.getTextTrim());
        }
        if ((e = element.getChild("track-configs")) != null) {
            List trackConfigElements = e.getChildren("track-config");
            TrackConfig[] trackConfigs = new TrackConfig[trackConfigElements.size()];
            for (int j = 0; j < trackConfigElements.size(); ++j) {
                trackConfigs[j] = new TrackConfig();
                Element e2 = (Element)trackConfigElements.get(j);
                Element e3 = e2.getChild("enabled");
                if (e3 != null) {
                    trackConfigs[j].enabled = e3.getTextTrim().equals("true");
                }
                if ((e3 = e2.getChild("format")) == null) continue;
                try {
                    trackConfigs[j].format = SerializationUtils.deserialize(e3.getTextTrim());
                    continue;
                }
                catch (IOException e1) {
                    logger.warning("Unable to deserialize format: " + e3.getTextTrim() + ": " + e1);
                    continue;
                }
                catch (ClassNotFoundException e1) {
                    logger.warning("Unable to deserialize format: " + e3.getTextTrim() + ": " + e1);
                }
            }
        }
        if ((e = element.getChild("dest-url")) != null) {
            String destUrlStr;
            processorWizardConfig.destUrl = destUrlStr = e.getTextTrim();
        }
    }

    private void parseElement_RTPTransmitWizardConfig(Element element) {
        this.rtpTransmitWizardConfig = new RTPTransmitWizardConfig();
        if (element != null) {
            PlayerPanelPrefs.parseElement_ProcessorWizardConfig(element, this.rtpTransmitWizardConfig);
        }
    }

    private void parseElement_TranscodeWizardConfig(Element element) {
        this.transcodeWizardConfig = new TranscodeWizardConfig();
        if (element != null) {
            PlayerPanelPrefs.parseElement_ProcessorWizardConfig(element, this.transcodeWizardConfig);
        }
    }

    private static Element buildElement_ProcessorWizardConfig(ProcessorWizardConfig processorWizardConfig, String elementStr) {
        Element e;
        Element element = new Element(elementStr);
        if (processorWizardConfig.url != null) {
            e = new Element("source-url");
            e.setText(processorWizardConfig.url);
            element.addContent((Content)e);
        }
        if (processorWizardConfig.contentDescriptor != null) {
            e = new Element("content-descriptor-encoding");
            e.setText(processorWizardConfig.contentDescriptor.getEncoding());
            element.addContent((Content)e);
        }
        if (processorWizardConfig.trackConfigs != null) {
            e = new Element("track-configs");
            element.addContent((Content)e);
            for (int i = 0; i < processorWizardConfig.trackConfigs.length; ++i) {
                TrackConfig trackConfig = processorWizardConfig.trackConfigs[i];
                Element e2 = new Element("track-config");
                e.addContent((Content)e2);
                Element e3 = new Element("enabled");
                e2.addContent((Content)e3);
                e3.setText("" + trackConfig.enabled);
                if (trackConfig.format == null) continue;
                e3 = new Element("format-serialized");
                try {
                    e3.setText(SerializationUtils.serialize(trackConfig.format));
                    e2.addContent((Content)e3);
                    continue;
                }
                catch (IOException e1) {
                    logger.warning("Unable to serialize format: " + trackConfig.format + ": " + e);
                }
            }
        }
        if (processorWizardConfig.destUrl != null) {
            e = new Element("dest-url");
            e.setText(processorWizardConfig.destUrl.toString());
            element.addContent((Content)e);
        }
        return element;
    }

    private Element buildElement_RTPTransmitWizardConfig() {
        return PlayerPanelPrefs.buildElement_ProcessorWizardConfig(this.rtpTransmitWizardConfig, ELEMENT_RTP_TRANSMIT_WIZARD_CONFIG);
    }

    private Element buildElement_TranscodeWizardConfig() {
        return PlayerPanelPrefs.buildElement_ProcessorWizardConfig(this.transcodeWizardConfig, ELEMENT_TRANSCODE_WIZARD_CONFIG);
    }
}

