/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.application;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.MediaLocator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.sf.fmj.media.cdp.GlobalCaptureDevicePlugger;
import net.sf.fmj.utility.LoggerSingleton;

public class CaptureDeviceBrowser
extends JPanel {
    private static final Logger logger = LoggerSingleton.logger;
    private final JComboBox deviceComboBox;
    private final JButton okButton;
    private final JButton cancelButton;
    private boolean okClicked = false;
    private Map<Integer, MediaLocator> deviceComboBoxMap = new HashMap<Integer, MediaLocator>();

    public CaptureDeviceBrowser() {
        this.setLayout(new GridBagLayout());
        this.deviceComboBox = new JComboBox();
        this.deviceComboBox.setEditable(false);
        GridBagConstraints c1 = new GridBagConstraints();
        c1.fill = 2;
        c1.weightx = 1.0;
        c1.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.deviceComboBox, c1);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CaptureDeviceBrowser.this.okClicked = true;
                CaptureDeviceBrowser.this.closeDialog();
            }
        });
        GridBagConstraints c2 = new GridBagConstraints();
        c2.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.okButton, c2);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CaptureDeviceBrowser.this.closeDialog();
            }
        });
        this.add((Component)this.cancelButton, c2);
        this.populate();
        this.okButton.setEnabled(!this.deviceComboBoxMap.isEmpty());
        this.setPreferredSize(new Dimension(300, 80));
    }

    private void closeDialog() {
        this.getParent().getParent().getParent().getParent().setVisible(false);
        ((JDialog)this.getParent().getParent().getParent().getParent()).dispose();
    }

    private void populate() {
        GlobalCaptureDevicePlugger.addCaptureDevices();
        Vector vectorDevices = CaptureDeviceManager.getDeviceList(null);
        if (vectorDevices == null || vectorDevices.size() == 0) {
            return;
        }
        for (int i = 0; i < vectorDevices.size(); ++i) {
            CaptureDeviceInfo infoCaptureDevice = (CaptureDeviceInfo)vectorDevices.get(i);
            logger.fine("CaptureDeviceInfo: ");
            logger.fine(infoCaptureDevice.getName());
            logger.fine("" + infoCaptureDevice.getLocator());
            logger.fine("" + infoCaptureDevice.getFormats()[0]);
            this.deviceComboBox.addItem(infoCaptureDevice.getName());
            this.deviceComboBoxMap.put(new Integer(i), infoCaptureDevice.getLocator());
        }
    }

    public MediaLocator getSelectedMediaLocator() {
        int index = this.deviceComboBox.getSelectedIndex();
        if (index < 0) {
            return null;
        }
        return this.deviceComboBoxMap.get(index);
    }

    public static MediaLocator run(Frame parent) {
        JDialog frame = new JDialog();
        frame.setTitle("Select Capture Device");
        frame.setModal(true);
        Container contentPane = frame.getContentPane();
        CaptureDeviceBrowser panel = new CaptureDeviceBrowser();
        contentPane.add(panel);
        frame.pack();
        if (parent != null) {
            frame.setLocationRelativeTo(parent);
        }
        frame.setVisible(true);
        MediaLocator result = panel.okClicked ? panel.getSelectedMediaLocator() : null;
        return result;
    }

    public static void main(String[] args) {
        try {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "CaptureDeviceBrowser");
            logger.fine("" + CaptureDeviceBrowser.run(null));
            System.exit(0);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "" + t, t);
        }
    }
}

