/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.fmj.utility.FmjStartup;
import net.sf.fmj.utility.LoggerSingleton;

public class SSRCGenerator {
    private static final Logger logger = LoggerSingleton.logger;
    private static SecureRandom securePRNG = new SecureRandom();
    private static long startTime = System.currentTimeMillis();
    StringBuffer meat;
    private MessageDigest md5 = null;
    private Random PRNG = null;
    private static int counter = 0;
    private static Object counterLock = new Object();

    public SSRCGenerator() {
        String user = "username";
        if (!FmjStartup.isApplet) {
            user = System.getProperty("user.name");
        }
        int objHash = System.identityHashCode(this);
        String host = "localhost";
        if (!FmjStartup.isApplet) {
            try {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException ex) {
                logger.log(Level.WARNING, "" + ex, ex);
            }
        }
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            logger.log(Level.WARNING, "" + e, e);
        }
        this.meat = new StringBuffer();
        this.meat.append(user);
        this.meat.append("@");
        this.meat.append(host);
        this.meat.append(":");
        this.meat.append(Integer.toString(objHash));
        this.meat.append(":");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int generate() {
        int result;
        Object object = counterLock;
        synchronized (object) {
            result = this.generate(++counter);
        }
        return result;
    }

    public int generate(int salt) {
        long millis = System.currentTimeMillis();
        int pos = this.meat.length();
        int ssrc = 0;
        if (this.PRNG == null) {
            this.PRNG = new Random(SSRCGenerator.getSecuredSeed());
        }
        long rand = this.PRNG.nextLong();
        this.meat.append(Long.toString(millis));
        this.meat.append(":");
        this.meat.append(Long.toString(rand));
        this.meat.append(":");
        this.meat.append(Integer.toString(salt));
        this.md5.update(this.meat.toString().getBytes());
        byte[] hashed = this.md5.digest();
        this.meat.delete(pos, this.meat.length());
        int i = 0;
        while (i + 3 < hashed.length) {
            ssrc ^= hashed[i] << 24 | hashed[i + 1] << 16 | hashed[i + 2] << 8 | hashed[i + 3];
            i += 4;
        }
        return ssrc;
    }

    public static long getSecuredSeed() {
        byte[] gen = securePRNG.generateSeed(8);
        long genl = 0L;
        int shift = 56;
        for (int i = 0; i < 8; ++i) {
            genl |= (long)gen[i] << shift;
            shift -= 8;
        }
        return genl;
    }

    public static byte[] getSecuredSeed(int n) {
        return SecureRandom.getSeed(n);
    }

    public static long nextSecuredRandomLong() {
        return securePRNG.nextLong();
    }

    public static int nextSecuredRandomInt() {
        return securePRNG.nextInt();
    }

    public static short nextSecuredRandomShort() {
        return (short)(securePRNG.nextInt() & 0xFFFF);
    }

    public double random() {
        if (this.PRNG == null) {
            this.PRNG = new Random(SSRCGenerator.getSecuredSeed());
        }
        return this.PRNG.nextDouble();
    }
}

