/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.IOException;
import java.net.DatagramPacket;
import net.sf.fmj.media.rtp.RTCPHeader;

public class RTCPPacket {
    public static final int PT_SR = 200;
    public static final int PT_RR = 201;
    public static final int PT_SDES = 202;
    public static final int PT_BYE = 203;
    public static final int PT_APP = 204;
    private RTCPHeader header = null;
    private byte[] data = null;

    public RTCPPacket(DatagramPacket packet) throws IOException {
        this(packet.getData(), packet.getOffset(), packet.getLength());
    }

    public RTCPPacket(byte[] data, int offset, int length) throws IOException {
        this.header = new RTCPHeader(data, offset, length);
        this.data = new byte[length - 8];
        System.arraycopy(data, offset + 8, this.data, 0, length - 8);
    }

    public RTCPPacket(RTCPHeader header, byte[] data) {
        this.header = header;
        this.data = data;
    }

    public RTCPHeader getRtcpHeader() {
        return this.header;
    }

    public byte[] getRtcpData() {
        return this.data;
    }

    public int getRtcpLength() {
        return this.data.length;
    }
}

