/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.audio.ulaw;

import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import net.sf.fmj.media.AbstractCodec;
import net.sf.fmj.media.codec.audio.ulaw.MuLawEncoderUtil;
import net.sf.fmj.utility.LoggerSingleton;

public class Encoder
extends AbstractCodec {
    private static final Logger logger = LoggerSingleton.logger;
    protected Format[] outputFormats = new Format[]{new AudioFormat("ULAW", -1.0, 8, 1, -1, 1, 8, -1.0, Format.byteArray)};
    private static final boolean TRACE = false;

    public String getName() {
        return "ULAW Encoder";
    }

    public Encoder() {
        this.inputFormats = new Format[]{new AudioFormat("LINEAR", -1.0, 16, 1, -1, 1, 16, -1.0, Format.byteArray)};
    }

    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return this.outputFormats;
        }
        if (!(input instanceof AudioFormat)) {
            logger.warning(this.getClass().getSimpleName() + ".getSupportedOutputFormats: input format does not match, returning format array of {null} for " + input);
            return new Format[]{null};
        }
        AudioFormat inputCast = (AudioFormat)input;
        if (!inputCast.getEncoding().equals("LINEAR") || inputCast.getSampleSizeInBits() != 16 && inputCast.getSampleSizeInBits() != -1 || inputCast.getChannels() != 1 && inputCast.getChannels() != -1 || inputCast.getSigned() != 1 && inputCast.getSigned() != -1 || inputCast.getFrameSizeInBits() != 16 && inputCast.getFrameSizeInBits() != -1 || inputCast.getDataType() != null && inputCast.getDataType() != Format.byteArray) {
            logger.warning(this.getClass().getSimpleName() + ".getSupportedOutputFormats: input format does not match, returning format array of {null} for " + input);
            return new Format[]{null};
        }
        AudioFormat result = new AudioFormat("ULAW", inputCast.getSampleRate(), 8, 1, -1, 1, 8, inputCast.getFrameRate(), Format.byteArray);
        return new Format[]{result};
    }

    public void open() {
    }

    public void close() {
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        AudioFormat inputAudioFormat = (AudioFormat)inputBuffer.getFormat();
        byte[] outputBufferData = (byte[])outputBuffer.getData();
        int requiredOutputBufferLength = inputBuffer.getLength() / 2;
        if (outputBufferData == null || outputBufferData.length < requiredOutputBufferLength) {
            outputBufferData = new byte[requiredOutputBufferLength];
            outputBuffer.setData(outputBufferData);
        }
        if (!inputAudioFormat.equals(this.inputFormat)) {
            throw new RuntimeException("Incorrect input format");
        }
        if (inputAudioFormat.getEndian() == -1) {
            throw new RuntimeException("Unspecified endian-ness");
        }
        boolean bigEndian = inputAudioFormat.getEndian() == 1;
        MuLawEncoderUtil.muLawEncode(bigEndian, (byte[])inputBuffer.getData(), inputBuffer.getOffset(), inputBuffer.getLength(), outputBufferData);
        outputBuffer.setLength(requiredOutputBufferLength);
        outputBuffer.setOffset(0);
        outputBuffer.setFormat(this.outputFormat);
        boolean result = false;
        return 0;
    }

    public Format setInputFormat(Format arg0) {
        return super.setInputFormat(arg0);
    }

    public Format setOutputFormat(Format arg0) {
        return super.setOutputFormat(arg0);
    }
}

