/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.cdp.civil;

import com.lti.civil.CaptureException;
import com.lti.civil.CaptureStream;
import com.lti.civil.CaptureSystem;
import com.lti.civil.CaptureSystemFactory;
import com.lti.civil.DefaultCaptureSystemFactorySingleton;
import com.lti.civil.VideoFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.MediaLocator;
import net.sf.fmj.media.protocol.civil.DataSource;
import net.sf.fmj.utility.LoggerSingleton;

public class CaptureDevicePlugger {
    private static final Logger logger = LoggerSingleton.logger;
    private static final boolean QUERY_EXACT_FORMATS = true;

    public void addCaptureDevices() {
        try {
            CaptureSystemFactory factory = DefaultCaptureSystemFactorySingleton.instance();
            CaptureSystem system = factory.createCaptureSystem();
            system.init();
            List list = system.getCaptureDeviceInfoList();
            for (int i = 0; i < list.size(); ++i) {
                com.lti.civil.CaptureDeviceInfo civilInfo = (com.lti.civil.CaptureDeviceInfo)list.get(i);
                Format[] formats = CaptureDevicePlugger.getFormats(system, civilInfo.getDeviceID());
                CaptureDeviceInfo jmfInfo = new CaptureDeviceInfo("civil:" + civilInfo.getDescription() + ":" + i, new MediaLocator("civil:" + civilInfo.getDeviceID()), formats);
                if (CaptureDeviceManager.getDevice(jmfInfo.getName()) == null) {
                    CaptureDeviceManager.addDevice(jmfInfo);
                    logger.fine("CaptureDevicePlugger: Added " + jmfInfo.getLocator());
                    continue;
                }
                logger.fine("CaptureDevicePlugger: Already present, skipping " + jmfInfo.getLocator());
            }
        }
        catch (CaptureException e) {
            logger.log(Level.WARNING, "" + (Object)((Object)e), e);
        }
    }

    private static Format[] getFormats(CaptureSystem system, String deviceID) throws CaptureException {
        CaptureStream captureStream = system.openCaptureDeviceStream(deviceID);
        List formatList = captureStream.enumVideoFormats();
        Format[] formats = new Format[formatList.size()];
        for (int j = 0; j < formatList.size(); ++j) {
            formats[j] = DataSource.convertCivilFormat((VideoFormat)formatList.get(j));
        }
        captureStream.dispose();
        return formats;
    }
}

