/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.filtergraph;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.ResourceUnavailableException;
import javax.media.Track;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import net.sf.fmj.filtergraph.DemuxNode;
import net.sf.fmj.filtergraph.FilterGraphPrinter;
import net.sf.fmj.filtergraph.FilterGraphProcessor;
import net.sf.fmj.filtergraph.Link;
import net.sf.fmj.filtergraph.MuxNode;
import net.sf.fmj.filtergraph.Node;
import net.sf.fmj.filtergraph.RendererNode;

public class FilterGraph {
    public static final int PROCESS_DEFAULT = 0;
    public static final int SUPPRESS_TRACK_READ;
    private final DemuxNode root;

    public FilterGraph(DemuxNode root) {
        this.root = root;
    }

    public DemuxNode getRoot() {
        return this.root;
    }

    public int getNumTracks() {
        return this.root.getNumDestLinks();
    }

    public Track[] getTracks() {
        return this.root.getTracks();
    }

    public boolean isTrackEnabled(int i) {
        return this.root.getDestLink(i) != null;
    }

    public void openExcludeDemux() throws ResourceUnavailableException {
        for (int i = 0; i < this.root.getNumDestLinks(); ++i) {
            Link link = this.root.getDestLink(i);
            if (link == null) continue;
            FilterGraphProcessor.open(link.getDestNode());
        }
    }

    public void closeExcludeDemux() throws ResourceUnavailableException {
        for (int i = 0; i < this.root.getNumDestLinks(); ++i) {
            Link link = this.root.getDestLink(i);
            if (link == null) continue;
            FilterGraphProcessor.close(link.getDestNode());
        }
    }

    public void stop() throws IOException {
        FilterGraphProcessor.stop(this.root);
    }

    public void start() throws IOException {
        FilterGraphProcessor.start(this.root);
    }

    public FilterGraph duplicate() {
        return new FilterGraph((DemuxNode)this.root.duplicate());
    }

    public int process(Buffer input, int sourceTrackNumber, int destTrackNumber, int flags) {
        return FilterGraphProcessor.process(this.root, input, sourceTrackNumber, destTrackNumber, flags);
    }

    public int getVideoTrackIndex() {
        int trackIndex = -1;
        for (int i = 0; i < this.root.getTracks().length; ++i) {
            if (!this.root.getTracks()[i].isEnabled() || !(this.root.getTracks()[i].getFormat() instanceof VideoFormat)) continue;
            trackIndex = i;
            break;
        }
        return trackIndex;
    }

    public int getAudioTrackIndex() {
        int trackIndex = -1;
        for (int i = 0; i < this.root.getTracks().length; ++i) {
            if (!this.root.getTracks()[i].isEnabled() || !(this.root.getTracks()[i].getFormat() instanceof AudioFormat)) continue;
            trackIndex = i;
            break;
        }
        return trackIndex;
    }

    public DataSource getDataOutput() {
        for (int i = 0; i < this.getNumTracks(); ++i) {
            if (!this.isTrackEnabled(i)) continue;
            MuxNode muxNode = (MuxNode)FilterGraphProcessor.getTail(this.root.getDestLink(i).getDestNode());
            return muxNode.getMultiplexer().getDataOutput();
        }
        throw new RuntimeException("No mux node found");
    }

    public RendererNode getRendererNode(int trackIndex) {
        if (this.root.getDestLink(trackIndex) == null) {
            return null;
        }
        Node tail = FilterGraphProcessor.getTail(this.root.getDestLink(trackIndex).getDestNode());
        if (tail instanceof RendererNode) {
            return (RendererNode)tail;
        }
        return null;
    }

    public void printToLog() {
        FilterGraphPrinter.print(this.root, 1);
    }

    public Node getBeforeTail(int trackNumber) {
        return FilterGraphProcessor.getBeforeTail(this.root.getDestLink(trackNumber).getDestNode());
    }
}

