/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ffmpeg_java;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import net.sf.ffmpeg_java.AVCodecLibrary;
import net.sf.ffmpeg_java.AVFormatLibrary;
import net.sf.ffmpeg_java.AVUtilLibrary;
import net.sf.fmj.utility.LoggerSingleton;

public class ListFormats {
    private static final Logger logger = LoggerSingleton.logger;
    static final int CODEC_TYPE_UNKNOWN = -1;
    static final int CODEC_TYPE_VIDEO = 0;
    static final int CODEC_TYPE_AUDIO = 1;
    static final int CODEC_TYPE_DATA = 2;
    static final int CODEC_TYPE_SUBTITLE = 3;
    static final int CODEC_TYPE_NB = 4;
    static final AVFormatLibrary AVFORMAT = AVFormatLibrary.INSTANCE;
    static final AVCodecLibrary AVCODEC = AVCodecLibrary.INSTANCE;
    static final AVUtilLibrary AVUTIL = AVUtilLibrary.INSTANCE;
    static final String FIRST_FFMPEG_MUX_NAME = "ac3";
    static final String FIRST_FFMPEG_DECODER_NAME = "aasc";
    static final String FIRST_FFMPEG_ENCODER_NAME = "asv1";
    static final int JPEG_QUALITY = 100;

    public static void main(String[] args) throws Exception {
        AVFORMAT.av_register_all();
        ListFormats.listMuxes();
        ListFormats.listDecoder();
        ListFormats.listEncoder();
    }

    public static ContentDescriptor[] getSupportedOutputContentDescriptors(Format[] formats) {
        List contentDescriptors = ListFormats.listMuxes();
        return contentDescriptors.toArray(new ContentDescriptor[0]);
    }

    static List listMuxes() {
        ArrayList<String> contentDescriptors = new ArrayList<String>();
        int i = 1;
        AVFormatLibrary.AVOutputFormat avOutputFormat = AVFORMAT.guess_format(FIRST_FFMPEG_MUX_NAME, null, null);
        while (avOutputFormat != null) {
            String mimeType = null;
            mimeType = avOutputFormat.mime_type != null && avOutputFormat.mime_type.length() > 0 ? avOutputFormat.mime_type : "ffmpeg/" + avOutputFormat.name;
            logger.log(Level.FINEST, i++ + ". " + avOutputFormat.name + " - " + avOutputFormat.long_name + " : " + mimeType);
            contentDescriptors.add(ContentDescriptor.mimeTypeToPackageName(mimeType));
            if (avOutputFormat.next != null) {
                avOutputFormat = new AVFormatLibrary.AVOutputFormat(avOutputFormat.next);
                continue;
            }
            avOutputFormat = null;
        }
        return contentDescriptors;
    }

    static void listDecoder() {
        int i = 1;
        AVCodecLibrary.AVCodec avCodec = AVCODEC.avcodec_find_decoder_by_name(FIRST_FFMPEG_DECODER_NAME);
        while (avCodec != null) {
            logger.log(Level.FINEST, i++ + ". " + avCodec.name + " (" + ListFormats.getCodecType(avCodec.type) + ")");
            if (avCodec.next != null) {
                avCodec = new AVCodecLibrary.AVCodec(avCodec.next);
                continue;
            }
            avCodec = null;
        }
    }

    static void listEncoder() {
        int i = 1;
        AVCodecLibrary.AVCodec avCodec = AVCODEC.avcodec_find_decoder_by_name(FIRST_FFMPEG_ENCODER_NAME);
        while (avCodec != null) {
            logger.log(Level.FINEST, i++ + ". " + avCodec.name + " (" + ListFormats.getCodecType(avCodec.type) + ")");
            if (avCodec.next != null) {
                avCodec = new AVCodecLibrary.AVCodec(avCodec.next);
                continue;
            }
            avCodec = null;
        }
    }

    protected static String getCodecType(int codecType) {
        String result = null;
        switch (codecType) {
            case -1: {
                result = "unknown";
                break;
            }
            case 0: {
                result = "video";
                break;
            }
            case 1: {
                result = "audio";
                break;
            }
            case 2: {
                result = "data";
                break;
            }
            case 3: {
                result = "subtitle";
                break;
            }
            case 4: {
                result = "nb";
            }
        }
        return result;
    }

    public static VideoFormat convertCodecPixelFormat(int pixFmt, int width, int height, float frameRate) {
        RGBFormat result = null;
        int endianess = ListFormats.getCpuEndianess();
        switch (pixFmt) {
            case 2: {
                int red = 1;
                int green = 2;
                int blue = 3;
                int bitsPerPixel = 24;
                result = new RGBFormat(new Dimension(width, height), -1, Format.byteArray, frameRate, bitsPerPixel, red, green, blue);
                break;
            }
            case 3: {
                int red = 3;
                int green = 2;
                int blue = 1;
                int bitsPerPixel = 24;
                result = new RGBFormat(new Dimension(width, height), -1, Format.byteArray, frameRate, bitsPerPixel, red, green, blue);
                break;
            }
            case 6: {
                int red = 0xFF0000;
                int green = 65280;
                int blue = 255;
                int bitsPerPixel = 32;
                int pixelStride = 1;
                int lineStride = width * pixelStride;
                result = new RGBFormat(new Dimension(width, height), -1, Format.intArray, frameRate, bitsPerPixel, red, green, blue, pixelStride, lineStride, 0, endianess);
                break;
            }
            case 9: {
                int red = 31;
                int green = 2016;
                int blue = 63488;
                int bitsPerPixel = 16;
                int pixelStride = 1;
                int lineStride = width * pixelStride;
                result = new RGBFormat(new Dimension(width, height), -1, Format.shortArray, frameRate, bitsPerPixel, red, green, blue, pixelStride, lineStride, 0, endianess);
                break;
            }
            case 10: {
                int red = 31;
                int green = 992;
                int blue = 31744;
                int bitsPerPixel = 16;
                int pixelStride = 1;
                int lineStride = width * pixelStride;
                result = new RGBFormat(new Dimension(width, height), -1, Format.shortArray, frameRate, bitsPerPixel, red, green, blue, pixelStride, lineStride, 0, endianess);
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                break;
            }
            case 22: {
                int red = 255;
                int green = 65280;
                int blue = 0xFF0000;
                int bitsPerPixel = 32;
                int pixelStride = 1;
                int lineStride = width * pixelStride;
                result = new RGBFormat(new Dimension(width, height), -1, Format.intArray, frameRate, bitsPerPixel, red, green, blue, pixelStride, lineStride, 0, endianess);
                break;
            }
            case 23: {
                int red = 63488;
                int green = 2016;
                int blue = 31;
                int bitsPerPixel = 16;
                int pixelStride = 1;
                int lineStride = width * pixelStride;
                result = new RGBFormat(new Dimension(width, height), -1, Format.shortArray, frameRate, bitsPerPixel, red, green, blue, pixelStride, lineStride, 0, endianess);
                break;
            }
            case 24: {
                int red = 31744;
                int green = 992;
                int blue = 31;
                int bitsPerPixel = 16;
                int pixelStride = 1;
                int lineStride = width * pixelStride;
                result = new RGBFormat(new Dimension(width, height), -1, Format.shortArray, frameRate, bitsPerPixel, red, green, blue, pixelStride, lineStride, 0, endianess);
                break;
            }
            case 25: {
                int red = 224;
                int green = 28;
                int blue = 3;
                int bitsPerPixel = 8;
                result = new RGBFormat(new Dimension(width, height), -1, Format.byteArray, frameRate, bitsPerPixel, red, green, blue);
                break;
            }
            case 26: {
                break;
            }
            case 27: {
                int red = 8;
                int green = 6;
                int blue = 1;
                int bitsPerPixel = 8;
                result = new RGBFormat(new Dimension(width, height), -1, Format.byteArray, frameRate, bitsPerPixel, red, green, blue);
                break;
            }
            case 28: {
                int red = 7;
                int green = 56;
                int blue = 192;
                int bitsPerPixel = 8;
                result = new RGBFormat(new Dimension(width, height), -1, Format.byteArray, frameRate, bitsPerPixel, red, green, blue);
                break;
            }
            case 29: {
                break;
            }
            case 30: {
                int red = 1;
                int green = 6;
                int blue = 8;
                int bitsPerPixel = 8;
                result = new RGBFormat(new Dimension(width, height), -1, Format.byteArray, frameRate, bitsPerPixel, red, green, blue);
                break;
            }
            case 33: {
                break;
            }
            case 34: {
                break;
            }
            case 35: {
                break;
            }
            case 36: {
                break;
            }
            case -1: {
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                break;
            }
            case 20: {
                break;
            }
            case 21: {
                break;
            }
            case 7: {
                break;
            }
            case 5: {
                break;
            }
            case 1: {
                break;
            }
            case 37: {
                break;
            }
            case 38: {
                break;
            }
            case 40: {
                break;
            }
            case 31: {
                break;
            }
            case 32: {
                break;
            }
        }
        return result;
    }

    public static AudioFormat convertCodecAudioFormat(AVCodecLibrary.AVCodecContext codecCtx) {
        return new AudioFormat("LINEAR", codecCtx.sample_rate, 16, codecCtx.channels);
    }

    public static final boolean isBigEndian() {
        return ByteOrder.BIG_ENDIAN.equals(ByteOrder.nativeOrder());
    }

    public static final int getCpuEndianess() {
        return ListFormats.isBigEndian() ? 0 : 1;
    }

    public static int getPreferedPixelFormat() {
        return ListFormats.getPixelFormatFromBufferedImageType(ListFormats.getPreferedBufferedImageType());
    }

    public static int getPreferedBufferedImageType() {
        GraphicsDevice[] graphicsDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        GraphicsDevice graphicsDevice = graphicsDevices[0];
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getConfigurations()[0];
        return graphicsConfiguration.createCompatibleImage(1, 1).getType();
    }

    public static int getPixelFormatFromBufferedImageType(int bufferedImageType) {
        int pixelFormat;
        switch (bufferedImageType) {
            case 2: {
                pixelFormat = 6;
                break;
            }
            case 3: {
                pixelFormat = 6;
                break;
            }
            case 1: {
                pixelFormat = 6;
                break;
            }
            case 4: {
                pixelFormat = 22;
                break;
            }
            case 5: {
                pixelFormat = 3;
                break;
            }
            case 6: {
                pixelFormat = 22;
                break;
            }
            case 7: {
                pixelFormat = 22;
                break;
            }
            case 9: {
                pixelFormat = 10;
                break;
            }
            case 8: {
                pixelFormat = 9;
                break;
            }
            case 11: {
                if (ListFormats.isBigEndian()) {
                    pixelFormat = 35;
                    break;
                }
                pixelFormat = 36;
                break;
            }
            case 12: {
                pixelFormat = 6;
                break;
            }
            case 10: {
                pixelFormat = 11;
                break;
            }
            case 13: {
                pixelFormat = 14;
                break;
            }
            default: {
                pixelFormat = 6;
            }
        }
        return pixelFormat;
    }
}

