/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;
import net.sf.fmj.ejmf.toolkit.util.SourcedTimerEvent;
import net.sf.fmj.ejmf.toolkit.util.SourcedTimerListener;
import net.sf.fmj.ejmf.toolkit.util.TimeSource;

public class SourcedTimer
implements ActionListener {
    protected static int _defaultGran = 1000;
    private TimeSource source;
    private Timer baseTimer;
    private EventListenerList listenerList = null;
    private SourcedTimerEvent event;
    private boolean started = false;
    private Object[] listeners;

    public SourcedTimer(TimeSource src) {
        this(src, _defaultGran);
    }

    public SourcedTimer(TimeSource src, Timer timer) {
        this.source = src;
        this.event = new SourcedTimerEvent(this, 0L);
        this.baseTimer = timer;
    }

    public SourcedTimer(TimeSource src, int granularity) {
        this.source = src;
        this.event = new SourcedTimerEvent(this, 0L);
        this.baseTimer = new Timer(granularity, this);
        this.baseTimer.setInitialDelay(0);
    }

    public void start() {
        if (!this.started) {
            this.baseTimer.start();
            this.runNotifyThread(0L);
        }
    }

    public void stop() {
        this.started = false;
        this.baseTimer.stop();
        this.runNotifyThread(this.source.getTime());
    }

    public void actionPerformed(ActionEvent e) {
        this.runNotifyThread(this.source.getTime());
    }

    private void runNotifyThread(long nsecs) {
        this.event.setTime(nsecs);
        this.listeners = this.listenerList.getListenerList();
        Thread nThread = new Thread("SourcedTimer Notify Thread"){

            public void run() {
                for (int i = SourcedTimer.this.listeners.length - 2; i >= 0; i -= 2) {
                    if (SourcedTimer.this.listeners[i] != SourcedTimerListener.class) continue;
                    ((SourcedTimerListener)SourcedTimer.this.listeners[i + 1]).timerUpdate(SourcedTimer.this.event);
                }
            }
        };
        nThread.start();
    }

    public void addSourcedTimerListener(SourcedTimerListener l) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(SourcedTimerListener.class, l);
    }

    public long getConversionDivisor() {
        return this.source.getConversionDivisor();
    }
}

