/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.gui.controls.skins.ejmf;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIManager;
import net.sf.fmj.ejmf.toolkit.gui.controls.GainMeter;
import net.sf.fmj.ejmf.toolkit.gui.controls.skins.ejmf.BasicControlButton;

public class GainMeterButton
extends BasicControlButton
implements GainMeter {
    protected int intLevel;
    protected boolean muted;

    public void setLevel(float level) {
        this.intLevel = this.mapToMeterLevel(level);
        this.updateView();
    }

    public void setMute(boolean muted) {
        this.muted = muted;
        this.updateView();
    }

    public GainMeterButton() {
    }

    public GainMeterButton(float level, boolean muted) {
        this.setLevel(level);
        this.setMute(muted);
    }

    public void updateView() {
        this.repaint();
    }

    public int mapToMeterLevel(float gain) {
        int nticks = this.getResolution();
        int val = (int)(gain * 10.0f);
        int divisor = 10 / nticks;
        return val / divisor;
    }

    protected void paintIcon(Graphics g, int x, int y, int size, boolean isEnabled) {
        int i;
        int xtrans = this.muted ? x : x - 3;
        g.translate(xtrans, y);
        int midLen = size / 2;
        int magLen = size / 5;
        for (i = 0; i < size / 5; ++i) {
            g.drawLine(i, midLen - magLen, i, midLen + magLen);
        }
        for (i = 0; i < size; ++i) {
            g.drawLine(i, midLen - i, i, midLen + i);
        }
        int narcs = this.intLevel;
        if (!this.muted) {
            for (int i2 = 0; i2 < narcs; ++i2) {
                g.drawArc(size, midLen - (i2 + 1), i2 * 2, i2 * 2 + 1, 90, -180);
            }
        }
        if (this.muted) {
            g.translate(-2, -2);
            Color oldColor = g.getColor();
            g.setColor(Color.red);
            g.drawLine(0, 0, size + 2, size + 2);
            g.drawLine(0, size + 2, size + 2, 0);
            g.setColor(oldColor);
            g.translate(2, 2);
        }
        g.translate(-xtrans, -y);
    }

    public void paint(Graphics g) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        Color origColor = g.getColor();
        boolean isPressed = this.getModel().isPressed();
        boolean isEnabled = this.isEnabled();
        g.setColor(this.getBackground());
        g.fillRect(1, 1, w - 2, h - 2);
        if (isPressed) {
            g.setColor(UIManager.getColor("controlShadow"));
            g.drawRect(0, 0, w - 1, h - 1);
        } else {
            g.drawLine(0, 0, 0, h - 1);
            g.drawLine(1, 0, w - 2, 0);
            g.setColor(UIManager.getColor("controlHighlight"));
            g.drawLine(1, 1, 1, h - 3);
            g.drawLine(2, 1, w - 3, 1);
            g.setColor(UIManager.getColor("controlShadow"));
            g.drawLine(1, h - 2, w - 2, h - 2);
            g.drawLine(w - 2, 1, w - 2, h - 3);
            g.setColor(UIManager.getColor("controlDkShadow"));
            g.drawLine(0, h - 1, w - 1, h - 1);
            g.drawLine(w - 1, h - 1, w - 1, 0);
        }
        if (h < 5 || w < 5) {
            g.setColor(origColor);
            return;
        }
        if (isPressed) {
            g.translate(1, 1);
        }
        int size = Math.min((h - 4) / 3, (w - 4) / 3);
        size = Math.max(size, 2);
        this.paintIcon(g, (w - size) / 2, (h - size) / 2, size, isEnabled);
        if (isPressed) {
            g.translate(-1, -1);
        }
        g.setColor(origColor);
    }

    protected int getResolution() {
        return 5;
    }
}

