/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.gui.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import javax.media.Controller;
import javax.media.GainChangeEvent;
import javax.media.GainChangeListener;
import javax.media.GainControl;
import javax.swing.AbstractButton;
import javax.swing.SwingUtilities;
import net.sf.fmj.ejmf.toolkit.gui.controls.AbstractGainButtonPanel;
import net.sf.fmj.ejmf.toolkit.gui.controls.AbstractGainControl;
import net.sf.fmj.ejmf.toolkit.gui.controls.Skin;
import net.sf.fmj.ejmf.toolkit.gui.controls.StandardGainButtonPanel;

public class StandardGainControl
extends AbstractGainControl
implements GainChangeListener {
    public StandardGainControl(Skin skin, Controller controller) {
        super(skin, controller);
    }

    public StandardGainControl(Skin skin) {
        super(skin);
    }

    protected void setControllerHook(Controller newController) {
        super.setControllerHook(newController);
        if (this.isOperational()) {
            GainControl gc = this.getGainControl();
            this.setState(gc.getLevel());
            gc.addGainChangeListener(this);
        }
    }

    protected Component createControlComponent(Skin skin) {
        return new StandardGainButtonPanel(skin);
    }

    protected void addControlListener(EventListener listener) {
        if (!(listener instanceof ActionListener)) {
            throw new IllegalArgumentException("ActionListener required");
        }
        AbstractGainButtonPanel p = (AbstractGainButtonPanel)this.getControlComponent();
        AbstractButton ab = p.getGainIncreaseButton();
        ab.addActionListener((ActionListener)listener);
        ab = p.getGainDecreaseButton();
        ab.addActionListener((ActionListener)listener);
    }

    protected void removeControlListener(EventListener listener) {
        if (!(listener instanceof ActionListener)) {
            throw new IllegalArgumentException("ActionListener required");
        }
        StandardGainButtonPanel p = (StandardGainButtonPanel)this.getControlComponent();
        AbstractButton ab = p.getGainIncreaseButton();
        ab.removeActionListener((ActionListener)listener);
        ab = p.getGainDecreaseButton();
        ab.removeActionListener((ActionListener)listener);
    }

    protected EventListener createControlListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractGainButtonPanel gbp = (AbstractGainButtonPanel)StandardGainControl.this.getControlComponent();
                GainControl gc = StandardGainControl.this.getGainControl();
                float level = gc.getLevel();
                if (e.getSource() == gbp.getGainIncreaseButton()) {
                    gc.setLevel((level += 0.1f) > 1.0f ? 1.0f : level);
                } else if (e.getSource() == gbp.getGainDecreaseButton()) {
                    gc.setLevel((level -= 0.1f) < 0.0f ? 0.0f : level);
                }
            }
        };
    }

    public void gainChange(GainChangeEvent e) {
        SwingUtilities.invokeLater(new SetStateThread(e.getLevel()));
    }

    private void setState(float level) {
        AbstractGainButtonPanel gbp = (AbstractGainButtonPanel)this.getControlComponent();
        gbp.getGainIncreaseButton().setEnabled(level < 1.0f);
        gbp.getGainDecreaseButton().setEnabled(level > 0.0f);
    }

    public void setComponentAndListener(AbstractGainButtonPanel bp, ActionListener listener) {
        super.setComponentAndListener(bp, listener);
    }

    public void setComponent(AbstractGainButtonPanel bp) {
        super.setComponent(bp);
    }

    public void setControlListener(ActionListener listener) {
        super.setControlListener(listener);
    }

    class SetStateThread
    implements Runnable {
        float level;

        public SetStateThread(float level) {
            this.level = level;
        }

        public void run() {
            StandardGainControl.this.setState(this.level);
        }
    }
}

