/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.apps.mediaserver;

import fi.iki.elonen.nanohttpd.NanoHTTPD;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.DataSink;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Processor;
import javax.media.ProcessorModel;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.FileTypeDescriptor;
import net.sf.fmj.apps.mediaserver.StreamDataSink;
import net.sf.fmj.utility.FormatArgUtils;
import net.sf.fmj.utility.LoggerSingleton;

public class MediaHTTPD
extends NanoHTTPD {
    private static final Logger logger = LoggerSingleton.logger;

    public MediaHTTPD(int port) throws IOException {
        super(port);
    }

    public NanoHTTPD.Response serve(String uri, String method, Properties header, Properties parms) {
        InputStream is;
        Format outputFormat;
        String value;
        if (!uri.equals("/mediaserver")) {
            return super.serve(uri, method, header, parms);
        }
        logger.fine(method + " '" + uri + "' ");
        Enumeration<?> e = header.propertyNames();
        while (e.hasMoreElements()) {
            value = (String)e.nextElement();
            logger.fine("  HDR: '" + value + "' = '" + header.getProperty(value) + "'");
        }
        e = parms.propertyNames();
        while (e.hasMoreElements()) {
            value = (String)e.nextElement();
            logger.fine("  PRM: '" + value + "' = '" + parms.getProperty(value) + "'");
        }
        String mediaPath = parms.getProperty("media");
        String outputFormatStr = parms.getProperty("format");
        String mimeType = parms.getProperty("mime");
        logger.info("requested media: " + mediaPath);
        logger.info("requested mime type: " + mimeType);
        if (mediaPath == null) {
            return (NanoHTTPD)this.new NanoHTTPD.Response("403 Forbidden", "text/plain", "mediaPath parameter not specified");
        }
        if (mimeType == null) {
            return (NanoHTTPD)this.new NanoHTTPD.Response("403 Forbidden", "text/plain", "mimeType parameter not specified");
        }
        String serverSideUrlStr = mediaPath;
        FileTypeDescriptor outputContentDescriptor = new FileTypeDescriptor(ContentDescriptor.mimeTypeToPackageName(mimeType));
        if (outputFormatStr == null) {
            outputFormat = null;
        } else {
            try {
                outputFormat = FormatArgUtils.parse(outputFormatStr);
            }
            catch (ParseException e1) {
                logger.log(Level.WARNING, "" + e1, e1);
                return (NanoHTTPD)this.new NanoHTTPD.Response("403 Forbidden", "text/plain", "" + e1);
            }
        }
        logger.info("serverSideUrlStr: " + serverSideUrlStr);
        logger.info("outputContentDescriptor: " + outputContentDescriptor);
        logger.info("outputFormat: " + outputFormat);
        try {
            is = this.getInputStream(serverSideUrlStr, outputFormat, outputContentDescriptor);
        }
        catch (Exception e1) {
            return (NanoHTTPD)this.new NanoHTTPD.Response("403 Forbidden", "text/plain", "" + e1);
        }
        String responseMimeType = mimeType.equals("multipart/x-mixed-replace") ? mimeType + ";boundary=" + "--ssBoundaryFMJ" : mimeType;
        logger.info("Response mime type: " + responseMimeType);
        return (NanoHTTPD)this.new NanoHTTPD.Response("200 OK", responseMimeType, is);
    }

    private InputStream getInputStream(String urlStr, Format outputFormat, ContentDescriptor outputContentDescriptor) throws Exception {
        Format[] formatArray;
        MediaLocator mediaLocator = new MediaLocator(urlStr);
        if (outputFormat == null) {
            formatArray = null;
        } else {
            Format[] formatArray2 = new Format[1];
            formatArray = formatArray2;
            formatArray2[0] = outputFormat;
        }
        ProcessorModel processorModel = new ProcessorModel(mediaLocator, formatArray, outputContentDescriptor);
        final Processor processor = Manager.createRealizedProcessor(processorModel);
        DataSource ds = processor.getDataOutput();
        final DataSink[] streamDataSinkHolder = new DataSink[]{null};
        PipedInputStream in = new PipedInputStream(){

            public void close() throws IOException {
                super.close();
                logger.fine("Closed input stream");
                logger.fine("Stopping processor");
                processor.stop();
                logger.fine("Closing processor");
                processor.close();
                logger.fine("Deallocating processor");
                processor.deallocate();
                if (streamDataSinkHolder[0] != null) {
                    logger.fine("Closing StreamDataSink");
                    streamDataSinkHolder[0].close();
                }
            }
        };
        PipedOutputStream out = new PipedOutputStream(in);
        StreamDataSink streamDataSink = new StreamDataSink(out);
        streamDataSinkHolder[0] = streamDataSink;
        streamDataSink.setSource(ds);
        streamDataSink.open();
        streamDataSink.start();
        logger.info("Starting processor");
        processor.start();
        return in;
    }
}

