/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil.detector;

import eu.medsea.mimeutil.MimeException;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.handler.MimeHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class MimeDetector {
    private SortedSet mimeHandlers = new TreeSet();

    public final String getName() {
        return this.getClass().getName();
    }

    public final void addMimeHandler(MimeHandler mimeHandler) {
        this.mimeHandlers.add(mimeHandler);
    }

    public final boolean removeMimeHandler(MimeHandler mimeHandler) {
        return this.mimeHandlers.remove(mimeHandler);
    }

    public final Set getMimeHandlers() {
        return this.mimeHandlers;
    }

    private Collection fireMimeHandlers(Collection collection) {
        block0: for (MimeHandler mimeHandler : this.mimeHandlers) {
            for (MimeType mimeType : mimeHandler.getMimeTypes()) {
                if (!collection.contains(mimeType)) continue;
                collection = mimeHandler.handle(collection);
                continue block0;
            }
        }
        return collection;
    }

    public final Collection getMimeTypes(byte[] byArray) {
        return this.fireMimeHandlers(this.getMimeTypesByteArray(byArray));
    }

    public final Collection getMimeTypes(URLConnection uRLConnection) {
        try {
            Collection collection = this.fireMimeHandlers(this.getMimeTypesInputStream(new BufferedInputStream(uRLConnection.getInputStream())));
            if (collection.isEmpty()) {
                collection.add(uRLConnection.getContentType());
            }
            return collection;
        }
        catch (IOException iOException) {
            throw new MimeException(iOException);
        }
    }

    public final Collection getMimeTypes(File file) throws MimeException {
        return this.fireMimeHandlers(this.getMimeTypesFile(file));
    }

    public final Collection getMimeTypes(String string) throws MimeException {
        return this.fireMimeHandlers(this.getMimeTypesFile(new File(string)));
    }

    public final Collection getMimeTypes(InputStream inputStream) throws MimeException {
        return this.fireMimeHandlers(this.getMimeTypesInputStream(inputStream));
    }

    public abstract String getDescription();

    public abstract Collection getMimeTypesFile(File var1) throws UnsupportedOperationException;

    public abstract Collection getMimeTypesInputStream(InputStream var1) throws UnsupportedOperationException;

    public abstract Collection getMimeTypesByteArray(byte[] var1) throws UnsupportedOperationException;
}

