/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.google.common.collect.ImmutableList;
import com.limegroup.gnutella.licenses.LicenseType;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentHelper;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.XMLStringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.limewire.util.NameValue;
import org.limewire.util.Objects;
import org.limewire.util.RPNParser;

class GenericXmlDocument
implements RPNParser.StringLookup,
LimeXMLDocument {
    static final String XML_LICENSE_ATTRIBUTE = "license__";
    static final String XML_LICENSE_TYPE_ATTRIBUTE = "licensetype__";
    static final String VERSION_STRING = "internal_version";
    static final int CURRENT_VERSION = 3;
    private volatile List<String> cachedKeywords = null;
    private final LicenseType licenseType;
    private final LimeXMLSchema schema;
    private final Map<String, String> data;
    private final String action;
    private File fileId;
    private volatile int version;
    private volatile int hashCode = 0;

    GenericXmlDocument(LimeXMLSchema schema, Map<String, String> map, int version, String action, LicenseType licenseType) {
        this.version = version;
        this.action = action == null ? "" : action;
        this.licenseType = Objects.nonNull(licenseType, "licenseType");
        this.schema = Objects.nonNull(schema, "schema");
        this.data = new HashMap<String, String>(Objects.nonNull(map, "map"));
    }

    public Set<Map.Entry<String, String>> getNameValueSet() {
        return this.data.entrySet();
    }

    @Override
    public String getValue(String fieldName) {
        return this.data.get(fieldName);
    }

    @Override
    public List<String> getKeyWords() {
        if (this.cachedKeywords != null) {
            return this.cachedKeywords;
        }
        ArrayList<String> retList = new ArrayList<String>();
        for (Map.Entry entry : this.getNameValueSet()) {
            String currKey = (String)entry.getKey();
            String val = (String)entry.getValue();
            if (val == null || val.equals("") || this.isIndivisible(currKey) || !this.isIndexableKey(currKey)) continue;
            try {
                Double.parseDouble(val);
            }
            catch (NumberFormatException ignored) {
                retList.add(val);
            }
        }
        this.cachedKeywords = ImmutableList.copyOf(retList);
        return retList;
    }

    @Override
    public int getNumFields() {
        return this.getNameValueSet().size();
    }

    @Override
    public List<String> getKeyWordsIndivisible() {
        return this.licenseType.getIndivisibleKeywords();
    }

    private boolean isIndivisible(String currKey) {
        return currKey.endsWith(XML_LICENSE_TYPE_ATTRIBUTE);
    }

    private boolean isIndexableKey(String key) {
        return !key.equals("torrents__torrent__filesizes__") && !key.equals("torrents__torrent__infohash__") && !key.equals("torrents__torrent__trackers__");
    }

    @Override
    public String getSchemaURI() {
        return this.getSchema().getSchemaURI();
    }

    @Override
    public LimeXMLSchema getSchema() {
        return this.schema;
    }

    @Override
    public File getIdentifier() {
        return this.fileId;
    }

    @Override
    public void initIdentifier(File id) {
        this.fileId = id;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public boolean isLicenseAvailable() {
        return this.licenseType != LicenseType.NO_LICENSE;
    }

    @Override
    public String getLicenseString() {
        if (this.isLicenseAvailable()) {
            String licenseStringSuffix = this.getVerifiableLicenseElement(this.licenseType);
            if (licenseStringSuffix == null) {
                return null;
            }
            for (Map.Entry next : this.getNameValueSet()) {
                String key = (String)next.getKey();
                if (!key.endsWith(licenseStringSuffix)) continue;
                return (String)next.getValue();
            }
        }
        return null;
    }

    protected String getVerifiableLicenseElement(LicenseType type) {
        if (type == LicenseType.CC_LICENSE) {
            return XML_LICENSE_ATTRIBUTE;
        }
        if (type.isDRMLicense()) {
            return XML_LICENSE_TYPE_ATTRIBUTE;
        }
        return null;
    }

    @Override
    public List<NameValue<String>> getOrderedNameValueList() {
        if (this.getSchema() == null) {
            return Collections.emptyList();
        }
        List<String> fNames = this.getSchema().getCanonicalizedFieldNames();
        ArrayList<NameValue<String>> retList = new ArrayList<NameValue<String>>(fNames.size());
        for (String fieldName : fNames) {
            String value = this.getValue(fieldName);
            if (value == null) continue;
            retList.add(new NameValue<String>(fieldName, value));
        }
        return retList;
    }

    @Override
    public String getXMLString() {
        StringBuilder fullXML = new StringBuilder();
        LimeXMLDocumentHelper.buildXML(fullXML, this.getSchema(), this.getAttributeString() + "/>");
        return fullXML.toString();
    }

    @Override
    public String getAttributeStringWithIndex(int i) {
        String attributes = this.getAttributeString();
        return attributes + " index=\"" + i + "\"/>";
    }

    private String getAttributeString() {
        return this.constructAttributeString();
    }

    String getXmlWithVersion() {
        StringBuilder fullXML = new StringBuilder();
        LimeXMLDocumentHelper.buildXML(fullXML, this.getSchema(), this.getAttributeString() + " " + VERSION_STRING + "=\"" + this.version + "\"/>");
        return fullXML.toString();
    }

    boolean isCurrent() {
        return this.version == 3;
    }

    void setCurrent() {
        this.version = 3;
    }

    private String constructAttributeString() {
        List<NameValue<String>> attributes = this.getOrderedNameValueList();
        if (attributes.isEmpty()) {
            return "";
        }
        StringBuilder tag = new StringBuilder();
        String root = this.getSchema().getRootXMLName();
        String type = this.getSchema().getInnerXMLName();
        String canonicalKey = root + "__" + type + "__";
        tag.append("<");
        tag.append(type);
        for (NameValue<String> nv : attributes) {
            String name = XMLStringUtils.getLastField(canonicalKey, nv.getName());
            if (name == null) continue;
            tag.append(" ");
            tag.append(name);
            tag.append("=\"");
            tag.append(LimeXMLUtils.encodeXML(nv.getValue()));
            tag.append("\"");
        }
        return tag.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericXmlDocument)) {
            return false;
        }
        GenericXmlDocument xmlDoc = (GenericXmlDocument)o;
        return this.action.equals(xmlDoc.getAction()) && this.version == xmlDoc.version && this.schema.equals(xmlDoc.schema) && ((Object)this.data).equals(xmlDoc.data);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.action.hashCode();
            result = 37 * result + this.schema.hashCode();
            this.hashCode = result = 37 * result + ((Object)this.data).hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return this.getXMLString();
    }

    @Override
    public String lookup(String key) {
        if (key == null) {
            return null;
        }
        if ("schema".equals(key)) {
            return this.getSchema().getDescription();
        }
        if ("numKWords".equals(key)) {
            return String.valueOf(this.getKeyWords().size());
        }
        if ("numKWordsI".equals(key)) {
            return String.valueOf(this.getKeyWordsIndivisible().size());
        }
        if ("numFields".equals(key)) {
            return String.valueOf(this.getNumFields());
        }
        if ("ver".equals(key)) {
            return String.valueOf(this.version);
        }
        if (key.startsWith("field_")) {
            key = key.substring(6, key.length());
            return this.getValue(key);
        }
        return null;
    }
}

