/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.limewire.core.settings.SearchSettings;
import org.limewire.util.I18NConvert;
import org.limewire.util.StringUtils;

public class QueryUtils {
    private static final List<String> TRIVIAL_WORDS = Arrays.asList("the", "an", "a", "and");
    public static final String DELIMITERS = " -._+/*()\\,";
    private static final char[] DELIMITERS_CHARACTERS;
    private static final String DELIMITERS_AND_ILLEGAL;

    public static final Set<String> extractKeywords(String str, boolean allowNumbers) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        QueryUtils.extractKeywords(str, allowNumbers, set);
        return set;
    }

    public static final void extractKeywords(String str, boolean allowNumbers, Set<String> set) {
        StringTokenizer st = new StringTokenizer(str, DELIMITERS_AND_ILLEGAL);
        while (st.hasMoreTokens()) {
            String currToken = st.nextToken().toLowerCase();
            if (!allowNumbers) {
                try {
                    Double.parseDouble(currToken);
                    continue;
                }
                catch (NumberFormatException normalWord) {
                    // empty catch block
                }
            }
            if (TRIVIAL_WORDS.contains(currToken)) continue;
            set.add(currToken);
        }
    }

    static final Set<String> extractKeywordsFromFileName(String fileName) {
        return QueryUtils.extractKeywords(QueryUtils.ripExtension(fileName), false);
    }

    public static final String removeIllegalChars(String str) {
        StringBuilder sb = new StringBuilder(str.length());
        StringTokenizer st = new StringTokenizer(str, DELIMITERS_AND_ILLEGAL);
        while (st.hasMoreTokens()) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(st.nextToken());
        }
        return sb.toString();
    }

    public static String ripExtension(String fileName) {
        int extStart = fileName.lastIndexOf(46);
        if (extStart == -1) {
            return fileName;
        }
        return fileName.substring(0, extStart);
    }

    public static String createQueryString(String name, boolean allowNumbers) {
        if (name == null) {
            throw new NullPointerException("null name");
        }
        String retString = null;
        name = I18NConvert.instance().getNorm(name);
        int maxLen = SearchSettings.MAX_QUERY_LENGTH.getValue();
        Set<String> keywords = QueryUtils.extractKeywords(QueryUtils.ripExtension(name), allowNumbers);
        if (keywords.isEmpty()) {
            retString = QueryUtils.removeIllegalChars(name);
            retString = StringUtils.truncate(retString, maxLen);
        } else {
            retString = QueryUtils.constructQueryStringFromKeywords(maxLen, keywords);
        }
        assert (retString.length() <= maxLen) : "Original filename: " + name + ", converted: " + retString;
        if (!keywords.isEmpty()) assert (!retString.equals("")) : "Original filename: " + name;
        return retString;
    }

    public static String constructQueryStringFromKeywords(int maxLen, Set<String> keywords) {
        StringBuilder queryFieldValue = new StringBuilder();
        for (String keyword : keywords) {
            String delimIncl;
            String string = delimIncl = queryFieldValue.length() == 0 ? "" : " ";
            if (queryFieldValue.length() + keyword.length() + delimIncl.length() > maxLen) continue;
            queryFieldValue.append(delimIncl);
            queryFieldValue.append(keyword);
        }
        if (queryFieldValue.length() == 0) {
            queryFieldValue.append(StringUtils.truncate(keywords.iterator().next(), maxLen));
        }
        return queryFieldValue.toString();
    }

    public static String createQueryString(String name) {
        return QueryUtils.createQueryString(name, false);
    }

    public static final boolean isDelimiter(char c) {
        return Arrays.binarySearch(DELIMITERS_CHARACTERS, c) >= 0;
    }

    public static float calculateRelevance(String filename, LimeXMLDocument doc, String query) {
        if (query.isEmpty()) {
            return 1.0f;
        }
        Set<String> resultWords = QueryUtils.extractKeywords(filename, false);
        if (doc != null) {
            for (Map.Entry<String, String> entry : doc.getNameValueSet()) {
                QueryUtils.extractKeywords(entry.getValue(), false, resultWords);
            }
        }
        Set<String> queryWords = QueryUtils.extractKeywords(query, false);
        float matches = 0.0f;
        for (String queryWord : queryWords) {
            if (!resultWords.contains(queryWord)) continue;
            matches += 1.0f;
        }
        return matches / (float)resultWords.size();
    }

    public static String mutateQuery(String query) {
        ArrayList<String> words = new ArrayList<String>(QueryUtils.extractKeywords(query, true));
        if (words.size() <= 1) {
            return query;
        }
        Collections.shuffle(words);
        return StringUtils.explode(words, " ");
    }

    static {
        char[] characters = DELIMITERS.toCharArray();
        Arrays.sort(characters);
        DELIMITERS_CHARACTERS = characters;
        char[] illegal = SearchSettings.ILLEGAL_CHARS.get();
        StringBuilder sb = new StringBuilder(DELIMITERS.length() + illegal.length);
        DELIMITERS_AND_ILLEGAL = sb.append(illegal).append(DELIMITERS).toString();
    }
}

