/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.google.inject.Provider;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.ResponseFactory;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.connection.BasicQueue;
import com.limegroup.gnutella.connection.ConnectionStats;
import com.limegroup.gnutella.connection.MessageWriter;
import com.limegroup.gnutella.connection.SentMessageHandler;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.FileView;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.OutgoingQueryReplyFactory;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.uploader.HTTPUploadSessionManager;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.HttpException;
import com.limegroup.gnutella.uploader.UploadType;
import com.limegroup.gnutella.uploader.authentication.HttpRequestFileViewProvider;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.RequestLine;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.ContentEncoderChannel;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.ConsumingNHttpEntity;
import org.apache.http.nio.protocol.SimpleNHttpRequestHandler;
import org.apache.http.protocol.HttpContext;
import org.limewire.collection.MultiIterable;
import org.limewire.core.api.browse.server.BrowseTracker;
import org.limewire.http.HttpCoreUtils;
import org.limewire.http.entity.AbstractProducingNHttpEntity;
import org.limewire.i18n.I18nMarker;
import org.limewire.io.GUID;
import org.limewire.nio.channel.NoInterestWritableByteChannel;

public class BrowseRequestHandler
extends SimpleNHttpRequestHandler {
    private static final Log LOG = LogFactory.getLog(BrowseRequestHandler.class);
    private final HTTPUploadSessionManager sessionManager;
    private final Provider<ResponseFactory> responseFactory;
    private final OutgoingQueryReplyFactory outgoingQueryReplyFactory;
    private boolean requestorCanDoFWT = true;
    private final HttpRequestFileViewProvider browseRequestFileListProvider;
    private final BrowseTracker tracker;

    BrowseRequestHandler(HTTPUploadSessionManager sessionManager, Provider<ResponseFactory> responseFactory, OutgoingQueryReplyFactory outgoingQueryReplyFactory, HttpRequestFileViewProvider browseRequestFileListProvider, BrowseTracker tracker) {
        this.sessionManager = sessionManager;
        this.responseFactory = responseFactory;
        this.outgoingQueryReplyFactory = outgoingQueryReplyFactory;
        this.browseRequestFileListProvider = browseRequestFileListProvider;
        this.tracker = tracker;
    }

    @Override
    public ConsumingNHttpEntity entityRequest(HttpEntityEnclosingRequest request, HttpContext context) throws org.apache.http.HttpException, IOException {
        return null;
    }

    @Override
    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws org.apache.http.HttpException, IOException {
        if (request.getHeaders(HTTPHeaderName.FW_NODE_INFO.name()).length > 0) {
            this.requestorCanDoFWT = true;
        }
        HTTPUploader uploader = null;
        try {
            String friendID;
            String uri = request.getRequestLine().getUri();
            if (uri.equals("/") || uri.startsWith("/?")) {
                friendID = null;
                uploader = this.sessionManager.getOrCreateUploader(request, context, UploadType.BROWSE_HOST, "");
            } else {
                friendID = this.getFriend(request);
                this.tracker.browsed(friendID);
                uploader = this.sessionManager.getOrCreateUploader(request, context, UploadType.BROWSE_HOST, friendID, friendID);
            }
            uploader.setState(Uploader.UploadStatus.BROWSE_HOST);
            Iterable<FileView> lists = this.browseRequestFileListProvider.getFileViews(friendID, context);
            ArrayList<Iterable<FileDesc>> iterables = new ArrayList<Iterable<FileDesc>>();
            for (FileView list : lists) {
                iterables.add(list.pausableIterable());
            }
            MultiIterable<FileDesc> files = new MultiIterable<FileDesc>(iterables.toArray(new Iterable[0]));
            if (!HttpCoreUtils.hasHeaderListValue(request, "Accept", "application/x-gnutella-packets")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Browse request is missing Accept header");
                }
                response.setStatusCode(406);
            } else {
                response.setEntity(new BrowseResponseEntity(uploader, files, BrowseRequestHandler.shouldIncludeNMS1Urns(request)));
                response.setStatusCode(200);
            }
        }
        catch (HttpException he) {
            LOG.debug("invalid request", he);
            response.setStatusCode(he.getErrorCode());
            response.setReasonPhrase(he.getMessage());
        }
        if (uploader == null) {
            uploader = this.sessionManager.getOrCreateUploader(request, context, UploadType.BROWSE_HOST, I18nMarker.marktr("Browse"));
        }
        this.sessionManager.sendResponse(uploader, response);
    }

    static boolean shouldIncludeNMS1Urns(HttpRequest request) {
        boolean includeNMS1Urns = HttpCoreUtils.hasHeaderListValue(request, HTTPHeaderName.NMS1.httpStringValue(), "1");
        if (includeNMS1Urns) {
            return true;
        }
        Map<String, String> query = HttpCoreUtils.parseQuery(request.getRequestLine().getUri(), null);
        String nms1 = query.get("nms1");
        return nms1 != null && nms1.equals("1");
    }

    String getFriend(HttpRequest request) throws HttpException {
        RequestLine requestLine = request.getRequestLine();
        try {
            URI uri = new URI(requestLine.getUri());
            String path = uri.getPath();
            if (path == null) {
                throw new HttpException("no friend id:", 400);
            }
            if (path.endsWith("/")) {
                int previousSlash = path.lastIndexOf(47, path.length() - 2);
                if (previousSlash != -1) {
                    return path.substring(previousSlash + 1, path.length() - 1);
                }
            } else {
                int lastSlash = path.lastIndexOf(47);
                if (lastSlash != -1) {
                    return path.substring(lastSlash + 1);
                }
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        throw new HttpException("no friend id:", 400);
    }

    public class BrowseResponseEntity
    extends AbstractProducingNHttpEntity {
        private static final int RESPONSES_PER_REPLY = 10;
        private static final int MAX_PENDING_REPLIES = 5;
        private final HTTPUploader uploader;
        private Iterator<FileDesc> iterator;
        private MessageWriter sender;
        private volatile int pendingMessageCount = 0;
        private GUID sessionGUID = new GUID();
        private final boolean includeNMS1Urn;

        public BrowseResponseEntity(HTTPUploader uploader, Iterable<FileDesc> files, boolean includeNMS1Urn) {
            this.uploader = uploader;
            this.iterator = files.iterator();
            this.includeNMS1Urn = includeNMS1Urn;
            this.setContentType("application/x-gnutella-packets");
        }

        @Override
        public long getContentLength() {
            return -1L;
        }

        @Override
        public void initialize(ContentEncoder contentEncoder, IOControl ioctrl) throws IOException {
            SentMessageHandler sentMessageHandler = new SentMessageHandler(){

                @Override
                public void processSentMessage(Message m) {
                    BrowseResponseEntity.this.uploader.addAmountUploaded(m.getTotalLength());
                    BrowseResponseEntity.this.pendingMessageCount--;
                }
            };
            this.sender = new MessageWriter(new ConnectionStats(), new BasicQueue(), sentMessageHandler);
            this.sender.setWriteChannel(new NoInterestWritableByteChannel(new ContentEncoderChannel(contentEncoder)));
        }

        @Override
        public boolean writeContent(ContentEncoder contentEncoder, IOControl ioctrl) throws IOException {
            this.addMessages();
            boolean more = this.sender.handleWrite();
            assert (more || this.pendingMessageCount == 0);
            this.activateTimeout();
            return more || this.iterator.hasNext();
        }

        private void addMessages() {
            if (this.pendingMessageCount >= 5) {
                return;
            }
            ArrayList<Response> responses = new ArrayList<Response>(10);
            for (int i = 0; this.iterator.hasNext() && i < 10; ++i) {
                FileDesc fileDesc = this.iterator.next();
                Response response = ((ResponseFactory)BrowseRequestHandler.this.responseFactory.get()).createResponse(fileDesc, this.includeNMS1Urn);
                responses.add(response);
            }
            List<QueryReply> it = BrowseRequestHandler.this.outgoingQueryReplyFactory.createReplies(responses.toArray(new Response[0]), 10, null, this.sessionGUID.bytes(), (byte)1, false, BrowseRequestHandler.this.requestorCanDoFWT);
            for (QueryReply queryReply : it) {
                this.sender.send(queryReply);
                ++this.pendingMessageCount;
            }
        }

        @Override
        public void finish() {
            this.deactivateTimeout();
            this.sender = null;
        }

        @Override
        public void timeout() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Browse request timed out");
            }
            this.uploader.stop();
        }
    }
}

