/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.spam;

import com.limegroup.gnutella.spam.TemplateHashToken;
import com.limegroup.gnutella.spam.TemplateToken;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.security.SHA1;
import org.limewire.util.Base32;
import org.limewire.util.StringUtils;

public class TemplateHashTokenFactory {
    private static final Log LOG = LogFactory.getLog(TemplateHashTokenFactory.class);
    private static final String REPLACEMENT_STRING = "****";
    private final SHA1 sha1 = new SHA1();

    public TemplateHashToken create(String query, String filename) {
        query = query.trim().toLowerCase(Locale.US);
        if ((filename = filename.trim().toLowerCase(Locale.US)).contains(query)) {
            String template = filename.replace(query, REPLACEMENT_STRING);
            template = template.replaceFirst("^[0-9\\s]*", "");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created template: " + template);
            }
            return this.createFromTemplate(template);
        }
        LOG.debug("Did not create template");
        return null;
    }

    public TemplateHashToken convert(TemplateToken tt) {
        TemplateHashToken tht = this.createFromTemplate(tt.keyword);
        tht.setRating(tt.getRating());
        return tht;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TemplateHashToken createFromTemplate(String template) {
        byte[] utf8 = StringUtils.toUTF8Bytes(template);
        TemplateHashTokenFactory templateHashTokenFactory = this;
        synchronized (templateHashTokenFactory) {
            this.sha1.reset();
            this.sha1.engineUpdate(utf8, 0, utf8.length);
            byte[] hash = this.sha1.digest();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Template hash: " + Base32.encode(hash));
            }
            return new TemplateHashToken(hash);
        }
    }
}

