/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.simpp;

import com.limegroup.gnutella.security.Certificate;
import com.limegroup.gnutella.security.CertificateParserImpl;
import com.limegroup.gnutella.security.CertifiedMessageVerifier;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.Base32;
import org.limewire.util.StringUtils;
import org.limewire.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimppParser {
    private static final Log LOG = LogFactory.getLog(SimppParser.class);
    public static final String VERSION = "version";
    public static final String PROPS = "props";
    public static final String KEY_VERSION = "keyversion";
    public static final String NEW_VERSION = "newversion";
    public static final String SIGNATURE = "signature";
    public static final String CERTIFICATE = "certificate";
    private int _version;
    private String _propsData;
    private int keyVersion = -1;
    private int newVersion = -1;
    private byte[] signature;
    private byte[] signedPayload;
    private Certificate certificate;

    public SimppParser(byte[] dataBytes) throws IOException {
        this.parseInfo(new String(dataBytes, "UTF-8"));
    }

    public int getVersion() {
        return this._version;
    }

    public int getNewVersion() {
        return this.newVersion;
    }

    public String getPropsData() {
        return this._propsData;
    }

    int getKeyVersion() {
        return this.keyVersion;
    }

    byte[] getSignature() {
        return this.signature;
    }

    Certificate getCertificate() {
        return this.certificate;
    }

    private void parseInfo(String xmlStr) throws IOException {
        if (xmlStr == null || xmlStr.equals("")) {
            throw new IOException("null xml for version info");
        }
        Document d = XMLUtils.getDocument(xmlStr, LOG);
        Element docElement = d.getDocumentElement();
        NodeList children = docElement.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = children.item(i);
            String nodeName = node.getNodeName().toLowerCase(Locale.US).trim();
            String value = LimeXMLUtils.getText(node.getChildNodes());
            if (nodeName.equals(VERSION)) {
                this._version = LimeXMLUtils.parseInteger(value, -1);
                continue;
            }
            if (nodeName.equals(KEY_VERSION)) {
                this.keyVersion = LimeXMLUtils.parseInteger(value, -1);
                continue;
            }
            if (nodeName.equals(NEW_VERSION)) {
                this.newVersion = LimeXMLUtils.parseInteger(value, -1);
                continue;
            }
            if (nodeName.equals(SIGNATURE)) {
                this.signature = Base32.decode(value);
                this.signedPayload = StringUtils.toUTF8Bytes(LimeXMLUtils.stripElement(xmlStr, SIGNATURE));
                continue;
            }
            if (nodeName.equals(CERTIFICATE)) {
                this.certificate = new CertificateParserImpl().parseCertificate(value);
                continue;
            }
            if (!nodeName.equals(PROPS)) continue;
            this._propsData = value;
        }
        if (this.keyVersion <= -1 || this.newVersion <= -1 || this.signature == null) {
            throw new IOException("missing or invalid data: " + StringUtils.toString(this, this.keyVersion, this.newVersion, this.signature));
        }
    }

    public CertifiedMessageVerifier.CertifiedMessage getCertifiedMessage() {
        return new CertifiedMessageVerifier.CertifiedMessage(){

            @Override
            public byte[] getSignature() {
                return SimppParser.this.signature;
            }

            @Override
            public byte[] getSignedPayload() {
                return SimppParser.this.signedPayload;
            }

            @Override
            public int getKeyVersion() {
                return SimppParser.this.keyVersion;
            }

            @Override
            public Certificate getCertificate() {
                return SimppParser.this.certificate;
            }

            public String toString() {
                return StringUtils.toString(SimppParser.this, SimppParser.this.keyVersion, SimppParser.this.signature, SimppParser.this.signedPayload, SimppParser.this.certificate);
            }
        };
    }
}

