/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.simpp;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HttpClientListener;
import com.limegroup.gnutella.http.HttpExecutor;
import com.limegroup.gnutella.security.Certificate;
import com.limegroup.gnutella.security.CertificateProvider;
import com.limegroup.gnutella.security.CertifiedMessageSourceType;
import com.limegroup.gnutella.security.CertifiedMessageVerifier;
import com.limegroup.gnutella.security.DefaultSignedMessageDataProvider;
import com.limegroup.gnutella.settings.SimppSettingsManager;
import com.limegroup.gnutella.simpp.Simpp;
import com.limegroup.gnutella.simpp.SimppDataVerifier;
import com.limegroup.gnutella.simpp.SimppListener;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.simpp.SimppParser;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.params.AbstractHttpParams;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.limewire.core.settings.UpdateSettings;
import org.limewire.http.httpclient.HttpClientInstanceUtils;
import org.limewire.io.IOUtils;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.Clock;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;

@Singleton
public class SimppManagerImpl
implements SimppManager {
    private static final Log LOG = LogFactory.getLog(SimppManagerImpl.class);
    private static int MIN_VERSION = 3;
    private static final String FILENAME = "simpp.xml";
    private static final Random RANDOM = new Random();
    private static final int IGNORE_ID = Integer.MAX_VALUE;
    private volatile byte[] _lastBytes = new byte[0];
    private volatile int _lastId = MIN_VERSION;
    private volatile int newVersion = MIN_VERSION;
    private final HttpRequestControl httpRequestControl = new HttpRequestControl();
    private final List<SimppListener> listeners = new CopyOnWriteArrayList<SimppListener>();
    private final CopyOnWriteArrayList<SimppSettingsManager> simppSettingsManagers;
    private final Clock clock;
    private final Provider<HttpExecutor> httpExecutor;
    private final ScheduledExecutorService backgroundExecutor;
    private final Provider<HttpParams> defaultParams;
    private final DefaultSignedMessageDataProvider simppDataProvider;
    private final HttpClientInstanceUtils httpClientUtils;
    private volatile List<String> maxedUpdateList = Arrays.asList("http://simpp1.limewire.com/v3/simpp.def", "http://simpp2.limewire.com/v3/simpp.def", "http://simpp3.limewire.com/v3/simpp.def", "http://simpp4.limewire.com/v3/simpp.def", "http://simpp5.limewire.com/v3/simpp.def", "http://simpp6.limewire.com/v3/simpp.def", "http://simpp7.limewire.com/v3/simpp.def", "http://simpp8.limewire.com/v3/simpp.def", "http://simpp9.limewire.com/v3/simpp.def", "http://simpp10.limewire.com/v3/simpp.def");
    private volatile int minMaxHttpRequestDelay = 60000;
    private volatile int maxMaxHttpRequestDelay = 1800000;
    private volatile int silentPeriodForMaxHttpRequest = 300000;
    private final CertifiedMessageVerifier simppMessageVerifier;
    private final SimppDataVerifier simppDataVerifier;
    private final CertificateProvider certificateProvider;

    @Inject
    public SimppManagerImpl(Clock clock, Provider<HttpExecutor> httpExecutor, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, @Named(value="defaults") Provider<HttpParams> defaultParams, @Simpp DefaultSignedMessageDataProvider simppDataProvider, HttpClientInstanceUtils httpClientUtils, @Simpp CertifiedMessageVerifier simppMessageVerifier, SimppDataVerifier simppDataVerifier, @Simpp CertificateProvider certificateProvider) {
        this.clock = clock;
        this.simppMessageVerifier = simppMessageVerifier;
        this.simppDataVerifier = simppDataVerifier;
        this.certificateProvider = certificateProvider;
        this.simppSettingsManagers = new CopyOnWriteArrayList();
        this.httpExecutor = httpExecutor;
        this.backgroundExecutor = backgroundExecutor;
        this.defaultParams = defaultParams;
        this.simppDataProvider = simppDataProvider;
        this.httpClientUtils = httpClientUtils;
    }

    List<String> getMaxUrls() {
        return this.maxedUpdateList;
    }

    void setMaxUrls(List<String> urls) {
        this.maxedUpdateList = urls;
    }

    int getMinHttpRequestUpdateDelayForMaxFailover() {
        return this.minMaxHttpRequestDelay;
    }

    int getMaxHttpRequestUpdateDelayForMaxFailover() {
        return this.maxMaxHttpRequestDelay;
    }

    void setMinHttpRequestUpdateDelayForMaxFailover(int min) {
        this.minMaxHttpRequestDelay = min;
    }

    void setMaxHttpRequestUpdateDelayForMaxFailover(int max) {
        this.maxMaxHttpRequestDelay = max;
    }

    int getSilentPeriodForMaxHttpRequest() {
        return this.silentPeriodForMaxHttpRequest;
    }

    void setSilentPeriodForMaxHttpRequest(int silentPeriodForMaxHttpRequest) {
        this.silentPeriodForMaxHttpRequest = silentPeriodForMaxHttpRequest;
    }

    @Override
    public void initialize() {
        LOG.trace("Initializing SimppManager");
        this.backgroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                SimppManagerImpl.this.handleDataInternal(FileUtils.readFileFully(new File(CommonUtils.getUserSettingsDir(), SimppManagerImpl.FILENAME)), CertifiedMessageSourceType.FROM_DISK, null);
                SimppManagerImpl.this.handleDataInternal(SimppManagerImpl.this.simppDataProvider.getDefaultSignedMessageData(), CertifiedMessageSourceType.FROM_DISK, null);
            }
        });
    }

    @Override
    public int getVersion() {
        return this._lastId;
    }

    @Override
    public int getKeyVersion() {
        return this.certificateProvider.get().getKeyVersion();
    }

    @Override
    public int getNewVersion() {
        return this.newVersion;
    }

    @Override
    public byte[] getSimppBytes() {
        return this._lastBytes;
    }

    @Override
    public void addSimppSettingsManager(SimppSettingsManager simppSettingsManager) {
        this.simppSettingsManagers.add(simppSettingsManager);
    }

    @Override
    public List<SimppSettingsManager> getSimppSettingsManagers() {
        return this.simppSettingsManagers;
    }

    @Override
    public void addListener(SimppListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(SimppListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void checkAndUpdate(final ReplyHandler handler, final byte[] data) {
        if (data != null) {
            this.backgroundExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    LOG.trace("Parsing new data...");
                    SimppManagerImpl.this.handleDataInternal(data, CertifiedMessageSourceType.FROM_NETWORK, handler);
                }
            });
        }
    }

    void handleDataInternal(byte[] data, CertifiedMessageSourceType updateType, ReplyHandler handler) {
        if (data == null) {
            LOG.warn("No data to handle.");
            return;
        }
        byte[] signedData = null;
        try {
            signedData = this.simppDataVerifier.extractSignedData(data);
        }
        catch (SignatureException se) {
            LOG.warn("Couldn't verify signature on data.");
            return;
        }
        SimppParser parser = null;
        try {
            parser = new SimppParser(signedData);
        }
        catch (IOException iox) {
            LOG.error("IOX parsing simpp data", iox);
            return;
        }
        CertifiedMessageVerifier.CertifiedMessage certifiedMessage = parser.getCertifiedMessage();
        Certificate certificate = null;
        try {
            certificate = this.simppMessageVerifier.verify(certifiedMessage, handler);
        }
        catch (SignatureException se) {
            LOG.error("message did not verify", se);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got data with version: " + parser.getNewVersion() + " from: " + (Object)((Object)updateType) + ", current version is: " + this.newVersion);
        }
        switch (updateType) {
            case FROM_NETWORK: {
                if (certifiedMessage.getKeyVersion() == Integer.MAX_VALUE) {
                    if (this.getKeyVersion() == Integer.MAX_VALUE) break;
                    this.doHttpMaxFailover();
                    break;
                }
                if (certificate.getKeyVersion() <= this.getKeyVersion() && (certificate.getKeyVersion() != this.getKeyVersion() || parser.getNewVersion() <= this.newVersion)) break;
                this.storeAndUpdate(data, parser, updateType, certificate);
                break;
            }
            case FROM_DISK: {
                if (parser.getNewVersion() <= this.newVersion) break;
                this.storeAndUpdate(data, parser, updateType, certificate);
                break;
            }
            case FROM_HTTP: {
                if (parser.getNewVersion() != Integer.MAX_VALUE || certifiedMessage.getKeyVersion() != Integer.MAX_VALUE) break;
                this.storeAndUpdate(data, parser, updateType, certificate);
            }
        }
    }

    private void storeAndUpdate(byte[] data, SimppParser parser, CertifiedMessageSourceType updateType, Certificate certificate) {
        CertifiedMessageVerifier.CertifiedMessage certifiedMessage = parser.getCertifiedMessage();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Retrieved new data from: " + (Object)((Object)updateType) + ", storing & updating");
        }
        if (certifiedMessage.getKeyVersion() == Integer.MAX_VALUE && updateType == CertifiedMessageSourceType.FROM_NETWORK) {
            throw new IllegalStateException("shouldn't be here!");
        }
        if (updateType == CertifiedMessageSourceType.FROM_NETWORK && this.httpRequestControl.isRequestPending()) {
            return;
        }
        if (certificate.getKeyVersion() == Integer.MAX_VALUE) assert (updateType != CertifiedMessageSourceType.FROM_NETWORK);
        this._lastId = parser.getVersion();
        this.newVersion = parser.getNewVersion();
        this._lastBytes = data;
        this.certificateProvider.set(certificate);
        if (updateType != CertifiedMessageSourceType.FROM_DISK) {
            FileUtils.verySafeSave(CommonUtils.getUserSettingsDir(), FILENAME, data);
        }
        for (SimppSettingsManager ssm : this.simppSettingsManagers) {
            ssm.updateSimppSettings(parser.getPropsData());
        }
        for (SimppListener listener : this.listeners) {
            listener.simppUpdated();
        }
    }

    private void doHttpMaxFailover() {
        long maxTimeAgo = this.clock.now() - (long)this.silentPeriodForMaxHttpRequest;
        if (!this.httpRequestControl.requestQueued() && UpdateSettings.LAST_SIMPP_FAILOVER.getValue() < maxTimeAgo) {
            int rndDelay = RANDOM.nextInt(this.maxMaxHttpRequestDelay) + this.minMaxHttpRequestDelay;
            final String rndUri = this.maxedUpdateList.get(RANDOM.nextInt(this.maxedUpdateList.size()));
            LOG.debug("Scheduling http max failover in: " + rndDelay + ", to: " + rndUri);
            this.backgroundExecutor.schedule(new Runnable(){

                @Override
                public void run() {
                    String url = rndUri;
                    try {
                        SimppManagerImpl.this.launchHTTPUpdate(url);
                    }
                    catch (URISyntaxException e) {
                        SimppManagerImpl.this.httpRequestControl.requestFinished();
                        SimppManagerImpl.this.httpRequestControl.cancelRequest();
                        LOG.warn("uri failure", e);
                    }
                }
            }, (long)rndDelay, TimeUnit.MILLISECONDS);
        } else {
            LOG.debug("Ignoring http max failover.");
        }
    }

    private void launchHTTPUpdate(String url) throws URISyntaxException {
        if (!this.httpRequestControl.isRequestPending()) {
            return;
        }
        LOG.debug("about to issue http request method");
        HttpGet get = new HttpGet(this.httpClientUtils.addClientInfoToUrl(url));
        get.addHeader("User-Agent", LimeWireUtils.getHttpServer());
        get.addHeader(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
        this.httpRequestControl.requestActive();
        AbstractHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout(params, 10000);
        HttpConnectionParams.setSoTimeout(params, 10000);
        params = new DefaultedHttpParams(params, this.defaultParams.get());
        this.httpExecutor.get().execute(get, params, new RequestHandler());
    }

    @Override
    public byte[] getOldUpdateResponse() {
        return this.simppDataProvider.getDisabledKeysSignedMessageData();
    }

    @Override
    public boolean shouldRequestSimppMessage(int version, int newVersion, int keyVersion) {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("version {0}, new version {1}, key version {2}", (Object)version, (Object)newVersion, (Object)keyVersion);
        }
        if (newVersion != -1 ? newVersion > this.getNewVersion() && keyVersion == this.getKeyVersion() : version > this.getVersion()) {
            return true;
        }
        return this.getKeyVersion() > MIN_VERSION && keyVersion > this.getKeyVersion();
    }

    private static class HttpRequestControl {
        private final AtomicBoolean requestQueued = new AtomicBoolean(false);
        private final AtomicBoolean requestActive = new AtomicBoolean(false);

        private HttpRequestControl() {
        }

        boolean isRequestPending() {
            return this.requestActive.get() || this.requestQueued.get();
        }

        boolean requestQueued() {
            boolean prior = this.requestQueued.getAndSet(true);
            return prior || this.requestActive.get();
        }

        void requestActive() {
            this.requestActive.set(true);
            this.requestQueued.set(false);
        }

        void cancelRequest() {
            this.requestQueued.set(false);
        }

        void requestFinished() {
            this.requestActive.set(false);
        }
    }

    private class RequestHandler
    implements HttpClientListener {
        private RequestHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean requestComplete(HttpUriRequest request, HttpResponse response) {
            byte[] inflated;
            LOG.debug("http request method succeeded");
            UpdateSettings.LAST_SIMPP_FAILOVER.setValue(SimppManagerImpl.this.clock.now());
            try {
                if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() >= 300) {
                    throw new IOException("bad code " + response.getStatusLine().getStatusCode());
                }
                byte[] resp = null;
                if (response.getEntity() != null) {
                    resp = IOUtils.readFully(response.getEntity().getContent());
                }
                if (resp == null || resp.length == 0) {
                    throw new IOException("bad body");
                }
                inflated = IOUtils.inflate(resp);
            }
            catch (IOException failed) {
                SimppManagerImpl.this.httpRequestControl.requestFinished();
                LOG.warn("couldn't fetch data ", failed);
                boolean bl = false;
                return bl;
            }
            finally {
                ((HttpExecutor)SimppManagerImpl.this.httpExecutor.get()).releaseResources(response);
            }
            SimppManagerImpl.this.backgroundExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    SimppManagerImpl.this.httpRequestControl.requestFinished();
                    LOG.trace("Parsing new data...");
                    SimppManagerImpl.this.handleDataInternal(inflated, CertifiedMessageSourceType.FROM_HTTP, null);
                }
            });
            return false;
        }

        @Override
        public boolean requestFailed(HttpUriRequest request, HttpResponse response, IOException exc) {
            LOG.warn("http failover failed", exc);
            SimppManagerImpl.this.httpRequestControl.requestFinished();
            UpdateSettings.LAST_SIMPP_FAILOVER.setValue(SimppManagerImpl.this.clock.now());
            ((HttpExecutor)SimppManagerImpl.this.httpExecutor.get()).releaseResources(response);
            return false;
        }

        @Override
        public boolean allowRequest(HttpUriRequest request) {
            return true;
        }
    }
}

